(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7721,        257]
NotebookOptionsPosition[      5624,        192]
NotebookOutlinePosition[      6759,        222]
CellTagsIndexPosition[      6716,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Epsilon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Epsilon"], 
          "\\[ScriptCapitalE]" :> 
          Documentation`HelpLookup["paclet:ref/character/ScriptCapitalE"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Epsilon]\"\>", 
       2->"\<\"\\\\[ScriptCapitalE]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Greek Letters" :> 
          Documentation`HelpLookup["paclet:guide/GreekLetters"], 
          "Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Greek Letters\"\>", 
       2->"\<\"Listing of Named Characters\"\>", 
       3->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CurlyEpsilon]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CurlyEpsilon]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->632427152],

Cell["\\[CurlyEpsilon]", "CharacterName",
 CellID->13165],

Cell["Unicode: 03B5.", "Notes",
 CellID->5946],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ce", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cepsilon", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->13540],

Cell["Greek letter. ", "Notes",
 CellID->27297],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Element"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->8042],

Cell["Used in physics for Fermi energy and dielectric constant. ", "Notes",
 CellID->14464]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23194],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->32200],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Epsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Epsilon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ScriptCapitalE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ScriptCapitalE"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->1206]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->67987254],

Cell[TextData[ButtonBox["Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GreekLetters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CurlyEpsilon] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 35.1008074}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03B5. Aliases: Esc ce Esc, Esc cepsilon Esc. Greek letter. Not \
the same as \\[Element]. Used in physics for Fermi energy and dielectric \
constant. ", "synonyms" -> {"curly epsilon"}, "title" -> "\\[CurlyEpsilon]", 
    "type" -> "Character Name", "uri" -> "ref/character/CurlyEpsilon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 82, 595, 19, 70, "CharacterImage",
 CellID->632427152],
Cell[3453, 103, 57, 1, 70, "CharacterName",
 CellID->13165],
Cell[3513, 106, 46, 1, 70, "Notes",
 CellID->5946],
Cell[3562, 109, 422, 15, 70, "Notes",
 CellID->13540],
Cell[3987, 126, 47, 1, 70, "Notes",
 CellID->27297],
Cell[4037, 129, 203, 7, 70, "Notes",
 CellID->8042],
Cell[4243, 138, 91, 1, 70, "Notes",
 CellID->14464]
}, Open  ]],
Cell[CellGroupData[{
Cell[4371, 144, 53, 1, 70, "TutorialsSection",
 CellID->23194],
Cell[4427, 147, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4637, 155, 50, 1, 70, "SeeAlsoSection",
 CellID->32200],
Cell[4690, 158, 408, 11, 70, "SeeAlso",
 CellID->1206]
}, Open  ]],
Cell[CellGroupData[{
Cell[5135, 174, 57, 1, 70, "MoreAboutSection",
 CellID->67987254],
Cell[5195, 177, 117, 2, 70, "MoreAbout"],
Cell[5315, 181, 143, 2, 70, "MoreAbout"],
Cell[5461, 185, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5597, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

