(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7659,        262]
NotebookOptionsPosition[      5620,        197]
NotebookOutlinePosition[      6725,        227]
CellTagsIndexPosition[      6682,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[DoubleDagger]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleDagger"], 
          "\\[ConjugateTranspose]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/ConjugateTranspose"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[DoubleDagger]\"\>", 
       2->"\<\"\\\\[ConjugateTranspose]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Dagger]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Dagger]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->154312839],

Cell["\\[Dagger]", "CharacterName",
 CellID->39],

Cell["Unicode: 2020.", "Notes",
 CellID->31283],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["dg", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3205],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->19997],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "\[Dagger]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperDagger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperDagger"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29146],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[ConjugateTranspose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->5769]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23675],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->917],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17442],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DoubleDagger]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleDagger"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ConjugateTranspose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->21735]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->348120454],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Dagger] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 42.6166248}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2020. Alias: Esc dg Esc. Letter-like form. x^\\[Dagger] is by \
default interpreted as SuperDagger[x]. Not the same as \
\\[ConjugateTranspose]. ", "synonyms" -> {"dagger"}, "title" -> "\\[Dagger]", 
    "type" -> "Character Name", "uri" -> "ref/character/Dagger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2200, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2823, 82, 583, 19, 70, "CharacterImage",
 CellID->154312839],
Cell[3409, 103, 48, 1, 70, "CharacterName",
 CellID->39],
Cell[3460, 106, 47, 1, 70, "Notes",
 CellID->31283],
Cell[3510, 109, 233, 9, 70, "Notes",
 CellID->3205],
Cell[3746, 120, 59, 1, 70, "Notes",
 CellID->19997],
Cell[3808, 123, 348, 13, 70, "Notes",
 CellID->29146],
Cell[4159, 138, 228, 8, 70, "Notes",
 CellID->5769]
}, Open  ]],
Cell[CellGroupData[{
Cell[4424, 151, 53, 1, 70, "TutorialsSection",
 CellID->23675],
Cell[4480, 154, 161, 3, 70, "Tutorials",
 CellID->917],
Cell[4644, 159, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4854, 167, 50, 1, 70, "SeeAlsoSection",
 CellID->17442],
Cell[4907, 170, 430, 12, 70, "SeeAlso",
 CellID->21735]
}, Open  ]],
Cell[CellGroupData[{
Cell[5374, 187, 58, 1, 70, "MoreAboutSection",
 CellID->348120454],
Cell[5435, 190, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5593, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

