(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9865,        324]
NotebookOptionsPosition[      7397,        249]
NotebookOutlinePosition[      8718,        282]
CellTagsIndexPosition[      8675,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       4->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[PartialD]" :> 
          Documentation`HelpLookup["paclet:ref/character/PartialD"], 
          "\\[CapitalDifferentialD]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/CapitalDifferentialD"], "\\[Delta]" :> 
          Documentation`HelpLookup["paclet:ref/character/Delta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[PartialD]\"\>", 
       2->"\<\"\\\\[CapitalDifferentialD]\"\>", 
       3->"\<\"\\\\[Delta]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[DifferentialD]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[DifferentialD]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->139323240],

Cell["\\[DifferentialD]", "CharacterName",
 CellID->7288],

Cell["Unicode: F74C.", "Notes",
 CellID->2382],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["dd", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->28074],

Cell["\<\
Compound operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->20333],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " can only be interpreted by default when it appears with ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " or other integral operators. "
}], "Notes",
 CellID->3915],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11056],

Cell[TextData[{
 Cell["\\[DifferentialD]", "InlineCharacterName"],
 " is also used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " to indicate total derivatives. "
}], "Notes",
 CellID->25656]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30062],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->24524],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->12129],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->1984]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23396],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[PartialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/PartialD"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalDifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalDifferentialD"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Delta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18026]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->4427673],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[DifferentialD] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 50.7574582}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F74C. Alias: Esc dd Esc. Compound operator with built-in \
evaluation rules. d can only be interpreted by default when it appears with \
\\[Integral] or other integral operators. \\[Integral] f dx is by default \
interpreted as Integrate[f,x]. \\[DifferentialD] is also used in \
TraditionalForm to indicate total derivatives. ", 
    "synonyms" -> {"differential d"}, "title" -> "\\[DifferentialD]", "type" -> 
    "Character Name", "uri" -> "ref/character/DifferentialD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2699, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3322, 90, 597, 19, 70, "CharacterImage",
 CellID->139323240],
Cell[3922, 111, 57, 1, 70, "CharacterName",
 CellID->7288],
Cell[3982, 114, 46, 1, 70, "Notes",
 CellID->2382],
Cell[4031, 117, 234, 9, 70, "Notes",
 CellID->28074],
Cell[4268, 128, 99, 3, 70, "Notes",
 CellID->20333],
Cell[4370, 133, 292, 8, 70, "Notes",
 CellID->3915],
Cell[4665, 143, 582, 22, 70, "Notes",
 CellID->11056],
Cell[5250, 167, 286, 9, 70, "Notes",
 CellID->25656]
}, Open  ]],
Cell[CellGroupData[{
Cell[5573, 181, 53, 1, 70, "TutorialsSection",
 CellID->30062],
Cell[5629, 184, 144, 3, 70, "Tutorials",
 CellID->24524],
Cell[5776, 189, 180, 5, 70, "Tutorials",
 CellID->12129],
Cell[5959, 196, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[6135, 201, 128, 3, 70, "Tutorials",
 CellID->1984]
}, Open  ]],
Cell[CellGroupData[{
Cell[6300, 209, 50, 1, 70, "SeeAlsoSection",
 CellID->23396],
Cell[6353, 212, 639, 18, 70, "SeeAlso",
 CellID->18026]
}, Open  ]],
Cell[CellGroupData[{
Cell[7029, 235, 56, 1, 70, "MoreAboutSection",
 CellID->4427673],
Cell[7088, 238, 143, 2, 70, "MoreAbout"],
Cell[7234, 242, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7370, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

