(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7844,        268]
NotebookOptionsPosition[      5863,        205]
NotebookOutlinePosition[      6963,        235]
CellTagsIndexPosition[      6920,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CapitalDigamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalDigamma"], 
          "\\[Koppa]" :> 
          Documentation`HelpLookup["paclet:ref/character/Koppa"], 
          "\\[Stigma]" :> 
          Documentation`HelpLookup["paclet:ref/character/Stigma"], 
          "\\[Sampi]" :> 
          Documentation`HelpLookup["paclet:ref/character/Sampi"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[CapitalDigamma]\"\>", 
       2->"\<\"\\\\[Koppa]\"\>", 3->"\<\"\\\\[Stigma]\"\>", 
       4->"\<\"\\\\[Sampi]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Digamma]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Digamma]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->302272164],

Cell["\\[Digamma]", "CharacterName",
 CellID->12060],

Cell["Unicode: 03DD.", "Notes",
 CellID->31175],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["di", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["digamma", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9074],

Cell["Special Greek letter. ", "Notes",
 CellID->5985],

Cell[TextData[{
 "Analogous to English ",
 Cell[BoxData["w"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32501],

Cell[TextData[{
 "Sometimes used to denote ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31622]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->13208],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->26291],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CapitalDigamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalDigamma"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Koppa]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Koppa"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Stigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Stigma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Sampi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sampi"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->31988]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->78116614],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Digamma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 50.9293376}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03DD. Aliases: Esc di Esc, Esc digamma Esc. Special Greek \
letter. Analogous to English w. Sometimes used to denote PolyGamma[x]. ", 
    "synonyms" -> {"digamma"}, "title" -> "\\[Digamma]", "type" -> 
    "Character Name", "uri" -> "ref/character/Digamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2224, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2847, 83, 585, 19, 70, "CharacterImage",
 CellID->302272164],
Cell[3435, 104, 52, 1, 70, "CharacterName",
 CellID->12060],
Cell[3490, 107, 47, 1, 70, "Notes",
 CellID->31175],
Cell[3540, 110, 420, 15, 70, "Notes",
 CellID->9074],
Cell[3963, 127, 54, 1, 70, "Notes",
 CellID->5985],
Cell[4020, 130, 114, 5, 70, "Notes",
 CellID->32501],
Cell[4137, 137, 252, 10, 70, "Notes",
 CellID->31622]
}, Open  ]],
Cell[CellGroupData[{
Cell[4426, 152, 53, 1, 70, "TutorialsSection",
 CellID->13208],
Cell[4482, 155, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4692, 163, 50, 1, 70, "SeeAlsoSection",
 CellID->26291],
Cell[4745, 166, 836, 24, 70, "SeeAlso",
 CellID->31988]
}, Open  ]],
Cell[CellGroupData[{
Cell[5618, 195, 57, 1, 70, "MoreAboutSection",
 CellID->78116614],
Cell[5678, 198, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5836, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

