(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6939,        236]
NotebookOptionsPosition[      4929,        174]
NotebookOutlinePosition[      6116,        205]
CellTagsIndexPosition[      6073,        202]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ContourIntegral]" :> 
          Documentation`HelpLookup["paclet:ref/character/ContourIntegral"], 
          "\\[Integral]" :> 
          Documentation`HelpLookup["paclet:ref/character/Integral"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[ContourIntegral]\"\>", 
       2->"\<\"\\\\[Integral]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[DoubleContourIntegral]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[DoubleContourIntegral]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->28425709],

Cell["\\[DoubleContourIntegral]", "CharacterName",
 CellID->17728],

Cell["Unicode: 222F.", "Notes",
 CellID->26260],

Cell["Compound operator. ", "Notes",
 CellID->12158],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[DoubleContourIntegral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{"ContourIntegral", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23425],

Cell["Used to indicate integrals over closed surfaces. ", "Notes",
 CellID->23267]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19312],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->734]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->29562],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ContourIntegral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ContourIntegral"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->1570]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->401925088],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[DoubleContourIntegral] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 58.7576630}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 222F. Compound operator. \\[DoubleContourIntegral] f ds is by \
default interpreted as ContourIntegral[f,s]. Used to indicate integrals over \
closed surfaces. ", "synonyms" -> {"double contour integral"}, "title" -> 
    "\\[DoubleContourIntegral]", "type" -> "Character Name", "uri" -> 
    "ref/character/DoubleContourIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1901, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2524, 76, 612, 19, 70, "CharacterImage",
 CellID->28425709],
Cell[3139, 97, 66, 1, 70, "CharacterName",
 CellID->17728],
Cell[3208, 100, 47, 1, 70, "Notes",
 CellID->26260],
Cell[3258, 103, 52, 1, 70, "Notes",
 CellID->12158],
Cell[3313, 106, 523, 19, 70, "Notes",
 CellID->23425],
Cell[3839, 127, 82, 1, 70, "Notes",
 CellID->23267]
}, Open  ]],
Cell[CellGroupData[{
Cell[3958, 133, 53, 1, 70, "TutorialsSection",
 CellID->19312],
Cell[4014, 136, 127, 3, 70, "Tutorials",
 CellID->734]
}, Open  ]],
Cell[CellGroupData[{
Cell[4178, 144, 50, 1, 70, "SeeAlsoSection",
 CellID->29562],
Cell[4231, 147, 415, 12, 70, "SeeAlso",
 CellID->1570]
}, Open  ]],
Cell[CellGroupData[{
Cell[4683, 164, 58, 1, 70, "MoreAboutSection",
 CellID->401925088],
Cell[4744, 167, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[4902, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

