(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7946,        281]
NotebookOptionsPosition[      5832,        216]
NotebookOutlinePosition[      7068,        248]
CellTagsIndexPosition[      7025,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftTee"], 
          "\\[DoubleRightTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleRightTee"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftTee]\"\>", 
       2->"\<\"\\\\[DoubleRightTee]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[DoubleLeftTee]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[DoubleLeftTee]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->38801376],

Cell["\\[DoubleLeftTee]", "CharacterName",
 CellID->7528],

Cell["Unicode: 2AE4.", "Notes",
 CellID->30916],

Cell["Infix operator. ", "Notes",
 CellID->12634],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubleLeftTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{"DoubleLeftTee", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4999],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubleLeftTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubleLeftTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " groups as ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubleLeftTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], ")"}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubleLeftTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17757],

Cell[TextData[{
 "Used in mathematics to indicate various strong forms of logical implication \
of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "\[LongDash]often tautological implication. "
}], "Notes",
 CellID->29240]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->581],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->13623]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31539],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftTee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleRightTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightTee"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->9299]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->146336291],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[DoubleLeftTee] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 37, 6.6484900}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2AE4. Infix operator. x =| y is by default interpreted as \
DoubleLeftTee[x,y]. x =| y =| z groups as (x =| y) =| z. Used in mathematics \
to indicate various strong forms of logical implication of x from y--often \
tautological implication. ", "synonyms" -> {"double left tee"}, "title" -> 
    "\\[DoubleLeftTee]", "type" -> "Character Name", "uri" -> 
    "ref/character/DoubleLeftTee"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1896, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2519, 76, 596, 19, 70, "CharacterImage",
 CellID->38801376],
Cell[3118, 97, 57, 1, 70, "CharacterName",
 CellID->7528],
Cell[3178, 100, 47, 1, 70, "Notes",
 CellID->30916],
Cell[3228, 103, 49, 1, 70, "Notes",
 CellID->12634],
Cell[3280, 106, 433, 17, 70, "Notes",
 CellID->4999],
Cell[3716, 125, 810, 34, 70, "Notes",
 CellID->17757],
Cell[4529, 161, 302, 10, 70, "Notes",
 CellID->29240]
}, Open  ]],
Cell[CellGroupData[{
Cell[4868, 176, 51, 1, 70, "TutorialsSection",
 CellID->581],
Cell[4922, 179, 129, 3, 70, "Tutorials",
 CellID->13623]
}, Open  ]],
Cell[CellGroupData[{
Cell[5088, 187, 50, 1, 70, "SeeAlsoSection",
 CellID->31539],
Cell[5141, 190, 408, 11, 70, "SeeAlso",
 CellID->9299]
}, Open  ]],
Cell[CellGroupData[{
Cell[5586, 206, 58, 1, 70, "MoreAboutSection",
 CellID->146336291],
Cell[5647, 209, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5805, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

