(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9172,        303]
NotebookOptionsPosition[      6985,        234]
NotebookOutlinePosition[      8134,        265]
CellTagsIndexPosition[      8091,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Other Mathematical Notation\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotElement]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotElement"], 
          "\\[ReverseElement]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReverseElement"], 
          "\\[Euro]" :> Documentation`HelpLookup["paclet:ref/character/Euro"],
           "\\[Epsilon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Epsilon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[NotElement]\"\>", 
       2->"\<\"\\\\[ReverseElement]\"\>", 3->"\<\"\\\\[Euro]\"\>", 
       4->"\<\"\\\\[Epsilon]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Element]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Element]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->1935787],

Cell["\\[Element]", "CharacterName",
 CellID->2829],

Cell["Unicode: 2208.", "Notes",
 CellID->31782],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]el\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]elem\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32705],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->26162],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Element]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15689],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Epsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Epsilon"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->15923]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30870],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->25342],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->9282],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14196]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18715],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotElement"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReverseElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReverseElement"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Euro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Euro"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Epsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Epsilon"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->16051]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->709155010],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Element] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 26.1661506}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2208. Aliases: Esc el Esc, Esc elem Esc. Infix operator with \
built-in evaluation rules. x \\[Element] y is by default interpreted as \
Element[x,y]. Not the same as \\[Epsilon]. ", "synonyms" -> {"element"}, 
    "title" -> "\\[Element]", "type" -> "Character Name", "uri" -> 
    "ref/character/Element"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2650, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3273, 88, 583, 19, 70, "CharacterImage",
 CellID->1935787],
Cell[3859, 109, 51, 1, 70, "CharacterName",
 CellID->2829],
Cell[3913, 112, 47, 1, 70, "Notes",
 CellID->31782],
Cell[3963, 115, 302, 11, 70, "Notes",
 CellID->32705],
Cell[4268, 128, 96, 3, 70, "Notes",
 CellID->26162],
Cell[4367, 133, 498, 20, 70, "Notes",
 CellID->15689],
Cell[4868, 155, 204, 7, 70, "Notes",
 CellID->15923]
}, Open  ]],
Cell[CellGroupData[{
Cell[5109, 167, 53, 1, 70, "TutorialsSection",
 CellID->30870],
Cell[5165, 170, 144, 3, 70, "Tutorials",
 CellID->25342],
Cell[5312, 175, 162, 3, 70, "Tutorials",
 CellID->9282],
Cell[5477, 180, 129, 3, 70, "Tutorials",
 CellID->14196]
}, Open  ]],
Cell[CellGroupData[{
Cell[5643, 188, 50, 1, 70, "SeeAlsoSection",
 CellID->18715],
Cell[5696, 191, 846, 24, 70, "SeeAlso",
 CellID->16051]
}, Open  ]],
Cell[CellGroupData[{
Cell[6579, 220, 58, 1, 70, "MoreAboutSection",
 CellID->709155010],
Cell[6640, 223, 143, 2, 70, "MoreAbout"],
Cell[6786, 227, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6958, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

