(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7520,        253]
NotebookOptionsPosition[      5511,        190]
NotebookOutlinePosition[      6639,        220]
CellTagsIndexPosition[      6596,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[EmptySquare]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptySquare"], 
          "\\[FilledSmallSquare]" :> 
          Documentation`HelpLookup["paclet:ref/character/FilledSmallSquare"], 
          "\\[Placeholder]" :> 
          Documentation`HelpLookup["paclet:ref/character/Placeholder"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[EmptySquare]\"\>", 
       2->"\<\"\\\\[FilledSmallSquare]\"\>", 
       3->"\<\"\\\\[Placeholder]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[EmptySmallSquare]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[EmptySmallSquare]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->664656915],

Cell["\\[EmptySmallSquare]", "CharacterName",
 CellID->17269],

Cell["Unicode: 25FB.", "Notes",
 CellID->5175],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["essq", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->31139],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->24696],

Cell[TextData[{
 "Not the same as the operator ",
 Cell[TextData[ButtonBox["\\[Square]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Square"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->19481],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Placeholder]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Placeholder"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->14471]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30268],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10806],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[EmptySquare]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySquare"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[FilledSmallSquare]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/FilledSmallSquare"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Placeholder]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Placeholder"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27109]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->556621658],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[EmptySmallSquare] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 27.2599286}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 25FB. Alias: Esc essq Esc. Letter-like form. Not the same as \
the operator \\[Square]. Not the same as \\[Placeholder]. ", 
    "synonyms" -> {"empty small square"}, "title" -> "\\[EmptySmallSquare]", 
    "type" -> "Character Name", "uri" -> "ref/character/EmptySmallSquare"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2148, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2771, 81, 603, 19, 70, "CharacterImage",
 CellID->664656915],
Cell[3377, 102, 61, 1, 70, "CharacterName",
 CellID->17269],
Cell[3441, 105, 46, 1, 70, "Notes",
 CellID->5175],
Cell[3490, 108, 236, 9, 70, "Notes",
 CellID->31139],
Cell[3729, 119, 59, 1, 70, "Notes",
 CellID->24696],
Cell[3791, 122, 215, 7, 70, "Notes",
 CellID->19481],
Cell[4009, 131, 212, 7, 70, "Notes",
 CellID->14471]
}, Open  ]],
Cell[CellGroupData[{
Cell[4258, 143, 53, 1, 70, "TutorialsSection",
 CellID->30268],
Cell[4314, 146, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4524, 154, 50, 1, 70, "SeeAlsoSection",
 CellID->10806],
Cell[4577, 157, 651, 18, 70, "SeeAlso",
 CellID->27109]
}, Open  ]],
Cell[CellGroupData[{
Cell[5265, 180, 58, 1, 70, "MoreAboutSection",
 CellID->556621658],
Cell[5326, 183, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5484, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

