(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7628,        254]
NotebookOptionsPosition[      5641,        191]
NotebookOutlinePosition[      6754,        221]
CellTagsIndexPosition[      6711,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ReturnKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnKey"], 
          "\\[ReturnIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnIndicator"], 
          "\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ReturnKey]\"\>", 
       2->"\<\"\\\\[ReturnIndicator]\"\>", 3->"\<\"\\\\[ControlKey]\"\>", 
       4->"\<\"\\\\[CommandKey]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[EnterKey]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[EnterKey]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->59839553],

Cell["\\[EnterKey]", "CharacterName",
 CellID->18442],

Cell["Unicode: F7D4.", "Notes",
 CellID->19280],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ent", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->10016],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->15290],

Cell[TextData[{
 "Representation of the ",
 StyleBox["Enter", "KeyEvent"],
 " key on a keyboard. "
}], "Notes",
 CellID->15098],

Cell["Used in describing how to type textual input. ", "Notes",
 CellID->9858]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->1730],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->8553]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->444],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ReturnKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->21649]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->72787126],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[EnterKey] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 34.4476126}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F7D4. Alias: Esc ent Esc. Letter-like form. Representation of \
the Enter key on a keyboard. Used in describing how to type textual input. ", 
    "synonyms" -> {"enter key"}, "title" -> "\\[EnterKey]", "type" -> 
    "Character Name", "uri" -> "ref/character/EnterKey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2294, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2917, 83, 586, 19, 70, "CharacterImage",
 CellID->59839553],
Cell[3506, 104, 53, 1, 70, "CharacterName",
 CellID->18442],
Cell[3562, 107, 47, 1, 70, "Notes",
 CellID->19280],
Cell[3612, 110, 235, 9, 70, "Notes",
 CellID->10016],
Cell[3850, 121, 59, 1, 70, "Notes",
 CellID->15290],
Cell[3912, 124, 127, 5, 70, "Notes",
 CellID->15098],
Cell[4042, 131, 78, 1, 70, "Notes",
 CellID->9858]
}, Open  ]],
Cell[CellGroupData[{
Cell[4157, 137, 52, 1, 70, "TutorialsSection",
 CellID->1730],
Cell[4212, 140, 195, 4, 70, "Tutorials",
 CellID->8553]
}, Open  ]],
Cell[CellGroupData[{
Cell[4444, 149, 48, 1, 70, "SeeAlsoSection",
 CellID->444],
Cell[4495, 152, 864, 24, 70, "SeeAlso",
 CellID->21649]
}, Open  ]],
Cell[CellGroupData[{
Cell[5396, 181, 57, 1, 70, "MoreAboutSection",
 CellID->72787126],
Cell[5456, 184, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5614, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

