(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8275,        272]
NotebookOptionsPosition[      6337,        209]
NotebookOutlinePosition[      7394,        239]
CellTagsIndexPosition[      7351,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CurlyEpsilon]" :> 
          Documentation`HelpLookup["paclet:ref/character/CurlyEpsilon"], 
          "\\[CapitalEpsilon]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalEpsilon"], 
          "\\[Eta]" :> Documentation`HelpLookup["paclet:ref/character/Eta"], 
          "\\[Euro]" :> Documentation`HelpLookup["paclet:ref/character/Euro"],
           "\\[Element]" :> 
          Documentation`HelpLookup["paclet:ref/character/Element"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[CurlyEpsilon]\"\>", 
       2->"\<\"\\\\[CapitalEpsilon]\"\>", 3->"\<\"\\\\[Eta]\"\>", 
       4->"\<\"\\\\[Euro]\"\>", 
       5->"\<\"\\\\[Element]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Epsilon]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Epsilon]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->234178831],

Cell["\\[Epsilon]", "CharacterName",
 CellID->30120],

Cell["Unicode: 03F5.", "Notes",
 CellID->32659],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["e", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["epsilon", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->488],

Cell["Greek letter. ", "Notes",
 CellID->30682],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Element"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->18341]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->2574],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->6500],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1552],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CurlyEpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyEpsilon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalEpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalEpsilon"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Eta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Eta"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Euro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Euro"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Element"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->850]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->250139362],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Epsilon] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 34.9163746}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03F5. Aliases: Esc e Esc, Esc epsilon Esc. Greek letter. Not \
the same as \\[Element]. ", "synonyms" -> {"epsilon"}, "title" -> 
    "\\[Epsilon]", "type" -> "Character Name", "uri" -> 
    "ref/character/Epsilon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2497, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3120, 86, 585, 19, 70, "CharacterImage",
 CellID->234178831],
Cell[3708, 107, 52, 1, 70, "CharacterName",
 CellID->30120],
Cell[3763, 110, 47, 1, 70, "Notes",
 CellID->32659],
Cell[3813, 113, 418, 15, 70, "Notes",
 CellID->488],
Cell[4234, 130, 47, 1, 70, "Notes",
 CellID->30682],
Cell[4284, 133, 204, 7, 70, "Notes",
 CellID->18341]
}, Open  ]],
Cell[CellGroupData[{
Cell[4525, 145, 52, 1, 70, "TutorialsSection",
 CellID->2574],
Cell[4580, 148, 152, 3, 70, "Tutorials",
 CellID->6500],
Cell[4735, 153, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4945, 161, 49, 1, 70, "SeeAlsoSection",
 CellID->1552],
Cell[4997, 164, 1057, 30, 70, "SeeAlso",
 CellID->850]
}, Open  ]],
Cell[CellGroupData[{
Cell[6091, 199, 58, 1, 70, "MoreAboutSection",
 CellID->250139362],
Cell[6152, 202, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6310, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

