(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8755,        287]
NotebookOptionsPosition[      6560,        220]
NotebookOutlinePosition[      7819,        252]
CellTagsIndexPosition[      7776,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[AliasIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/AliasIndicator"], 
          "\\[RawEscape]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawEscape"], 
          "\\[ReturnKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnKey"], 
          "\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[AliasIndicator]\"\>", 
       2->"\<\"\\\\[RawEscape]\"\>", 3->"\<\"\\\\[ReturnKey]\"\>", 
       4->"\<\"\\\\[ControlKey]\"\>", 
       5->"\<\"\\\\[CommandKey]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[EscapeKey]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[EscapeKey]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->519926190],

Cell["\\[EscapeKey]", "CharacterName",
 CellID->7629],

Cell["Unicode: F769.", "Notes",
 CellID->5560],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]esc", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29521],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->10597],

Cell[TextData[{
 "Representation of the ",
 StyleBox["Escape", "KeyEvent"],
 " key on a keyboard. "
}], "Notes",
 CellID->32189],

Cell[TextData[{
 "Used in describing how to type aliases for special characters in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->13163],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]esc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[TextData[ButtonBox["\\[AliasIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AliasIndicator"]], 
  "InlineCharacterName"],
 ". The alias for ",
 Cell[BoxData["\\[EscapeKey]"], "InlineCharacterName"],
 " has a space at the beginning. "
}], "Notes",
 CellID->30444]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18621],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->24705]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22334],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[AliasIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AliasIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawEscape]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawEscape"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->16999]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->603164285],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[EscapeKey] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 42.1509348}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F769. Alias: Esc  esc Esc. Letter-like form. Representation of \
the Escape key on a keyboard. Used in describing how to type aliases for \
special characters in Mathematica. Esc esc Esc is the alias for \
\\[AliasIndicator]. The alias for \\[EscapeKey] has a space at the beginning. \
", "synonyms" -> {"escape key"}, "title" -> "\\[EscapeKey]", "type" -> 
    "Character Name", "uri" -> "ref/character/EscapeKey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2430, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3053, 86, 589, 19, 70, "CharacterImage",
 CellID->519926190],
Cell[3645, 107, 53, 1, 70, "CharacterName",
 CellID->7629],
Cell[3701, 110, 46, 1, 70, "Notes",
 CellID->5560],
Cell[3750, 113, 252, 9, 70, "Notes",
 CellID->29521],
Cell[4005, 124, 59, 1, 70, "Notes",
 CellID->10597],
Cell[4067, 127, 128, 5, 70, "Notes",
 CellID->32189],
Cell[4198, 134, 169, 6, 70, "Notes",
 CellID->13163],
Cell[4370, 142, 445, 13, 70, "Notes",
 CellID->30444]
}, Open  ]],
Cell[CellGroupData[{
Cell[4852, 160, 53, 1, 70, "TutorialsSection",
 CellID->18621],
Cell[4908, 163, 196, 4, 70, "Tutorials",
 CellID->24705]
}, Open  ]],
Cell[CellGroupData[{
Cell[5141, 172, 50, 1, 70, "SeeAlsoSection",
 CellID->22334],
Cell[5194, 175, 1083, 30, 70, "SeeAlso",
 CellID->16999]
}, Open  ]],
Cell[CellGroupData[{
Cell[6314, 210, 58, 1, 70, "MoreAboutSection",
 CellID->603164285],
Cell[6375, 213, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6533, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

