(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7423,        254]
NotebookOptionsPosition[      5291,        187]
NotebookOutlinePosition[      6451,        218]
CellTagsIndexPosition[      6408,        215]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Sigma]" :> 
          Documentation`HelpLookup["paclet:ref/character/Sigma"], 
          "\\[Stigma]" :> 
          Documentation`HelpLookup["paclet:ref/character/Stigma"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Sigma]\"\>", 
       2->"\<\"\\\\[Stigma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[FinalSigma]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[FinalSigma]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->198641925],

Cell["\\[FinalSigma]", "CharacterName",
 CellID->26394],

Cell["Unicode: 03C2.", "Notes",
 CellID->31008],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["fs", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->17227],

Cell["Greek letter. ", "Notes",
 CellID->8835],

Cell[TextData[{
 "Used in written Greek when ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
 " occurs at the end of a word. "
}], "Notes",
 CellID->20577],

Cell["Not commonly used in technical notation. ", "Notes",
 CellID->5675],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Stigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Stigma"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->205]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20050],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1390],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Sigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sigma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Stigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Stigma"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18724]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->129864101],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[FinalSigma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 38, 51.3074192}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03C2. Alias: Esc fs Esc. Greek letter. Used in written Greek \
when \\[Sigma] occurs at the end of a word. Not commonly used in technical \
notation. Not the same as \\[Stigma]. ", "synonyms" -> {"final sigma"}, 
    "title" -> "\\[FinalSigma]", "type" -> "Character Name", "uri" -> 
    "ref/character/FinalSigma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2069, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2692, 79, 591, 19, 70, "CharacterImage",
 CellID->198641925],
Cell[3286, 100, 55, 1, 70, "CharacterName",
 CellID->26394],
Cell[3344, 103, 47, 1, 70, "Notes",
 CellID->31008],
Cell[3394, 106, 234, 9, 70, "Notes",
 CellID->17227],
Cell[3631, 117, 46, 1, 70, "Notes",
 CellID->8835],
Cell[3680, 120, 181, 6, 70, "Notes",
 CellID->20577],
Cell[3864, 128, 73, 1, 70, "Notes",
 CellID->5675],
Cell[3940, 131, 200, 7, 70, "Notes",
 CellID->205]
}, Open  ]],
Cell[CellGroupData[{
Cell[4177, 143, 53, 1, 70, "TutorialsSection",
 CellID->20050],
Cell[4233, 146, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4443, 154, 49, 1, 70, "SeeAlsoSection",
 CellID->1390],
Cell[4495, 157, 389, 11, 70, "SeeAlso",
 CellID->18724]
}, Open  ]],
Cell[CellGroupData[{
Cell[4921, 173, 58, 1, 70, "MoreAboutSection",
 CellID->129864101],
Cell[4982, 176, 143, 2, 70, "MoreAbout"],
Cell[5128, 180, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5264, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

