(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8745,        290]
NotebookOptionsPosition[      6660,        225]
NotebookOutlinePosition[      7779,        255]
CellTagsIndexPosition[      7736,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[GreaterSlantEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterSlantEqual"], 
          "\\[GreaterFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterFullEqual"], 
          "\\[NotGreaterEqual]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NotGreaterEqual"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[GreaterSlantEqual]\"\>", 
       2->"\<\"\\\\[GreaterFullEqual]\"\>", 
       3->"\<\"\\\\[NotGreaterEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>", 
       3->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[GreaterEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[GreaterEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->290425264],

Cell["\\[GreaterEqual]", "CharacterName",
 CellID->7448],

Cell["Unicode: 2265.", "Notes",
 CellID->21632],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox[">=", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->19141],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->2670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[GreaterEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GreaterEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GreaterEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15416]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3063],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->1818],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->18815]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17974],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[GreaterSlantEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterSlantEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[GreaterFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterFullEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotGreaterEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotGreaterEqual"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->1741]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->361514933],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[GreaterEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 39, 54.6371654}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2265. Alias: Esc >= Esc. Infix operator with built-in \
evaluation rules. x >= y is by default interpreted as GreaterEqual[x,y]. ", 
    "synonyms" -> {"greater equal"}, "title" -> "\\[GreaterEqual]", "type" -> 
    "Character Name", "uri" -> "ref/character/GreaterEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2622, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3245, 89, 595, 19, 70, "CharacterImage",
 CellID->290425264],
Cell[3843, 110, 56, 1, 70, "CharacterName",
 CellID->7448],
Cell[3902, 113, 47, 1, 70, "Notes",
 CellID->21632],
Cell[3952, 116, 234, 9, 70, "Notes",
 CellID->19141],
Cell[4189, 127, 95, 3, 70, "Notes",
 CellID->2670],
Cell[4287, 132, 513, 20, 70, "Notes",
 CellID->15416]
}, Open  ]],
Cell[CellGroupData[{
Cell[4837, 157, 52, 1, 70, "TutorialsSection",
 CellID->3063],
Cell[4892, 160, 143, 3, 70, "Tutorials",
 CellID->1818],
Cell[5038, 165, 129, 3, 70, "Tutorials",
 CellID->18815]
}, Open  ]],
Cell[CellGroupData[{
Cell[5204, 173, 50, 1, 70, "SeeAlsoSection",
 CellID->17974],
Cell[5257, 176, 674, 20, 70, "SeeAlso",
 CellID->1741]
}, Open  ]],
Cell[CellGroupData[{
Cell[5968, 201, 58, 1, 70, "MoreAboutSection",
 CellID->361514933],
Cell[6029, 204, 143, 2, 70, "MoreAbout"],
Cell[6175, 208, 283, 8, 70, "MoreAbout"],
Cell[6461, 218, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6633, 223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

