(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7927,        266]
NotebookOptionsPosition[      5915,        203]
NotebookOutlinePosition[      7060,        234]
CellTagsIndexPosition[      7017,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[GreaterEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterEqual"], 
          "\\[GreaterFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterFullEqual"], 
          "\\[NotGreaterSlantEqual]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NotGreaterSlantEqual"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[GreaterEqual]\"\>", 
       2->"\<\"\\\\[GreaterFullEqual]\"\>", 
       3->"\<\"\\\\[NotGreaterSlantEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[GreaterSlantEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[GreaterSlantEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->303940084],

Cell["\\[GreaterSlantEqual]", "CharacterName",
 CellID->26999],

Cell["Unicode: 2A7E.", "Notes",
 CellID->19898],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox[">/", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->11271],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->18386],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[GreaterSlantEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GreaterEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GreaterEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2192]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8552],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->16217]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->693],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[GreaterEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[GreaterFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterFullEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotGreaterSlantEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotGreaterSlantEqual"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->15089]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->315819894],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[GreaterSlantEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 39, 55.2621814}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2A7E. Alias: Esc >/ Esc. Infix operator with built-in \
evaluation rules. x >= y is by default interpreted as GreaterEqual[x,y]. ", 
    "synonyms" -> {"greater slant equal"}, "title" -> "\\[GreaterSlantEqual]",
     "type" -> "Character Name", "uri" -> 
    "ref/character/GreaterSlantEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2292, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2915, 83, 605, 19, 70, "CharacterImage",
 CellID->303940084],
Cell[3523, 104, 62, 1, 70, "CharacterName",
 CellID->26999],
Cell[3588, 107, 47, 1, 70, "Notes",
 CellID->19898],
Cell[3638, 110, 234, 9, 70, "Notes",
 CellID->11271],
Cell[3875, 121, 96, 3, 70, "Notes",
 CellID->18386],
Cell[3974, 126, 517, 20, 70, "Notes",
 CellID->2192]
}, Open  ]],
Cell[CellGroupData[{
Cell[4528, 151, 52, 1, 70, "TutorialsSection",
 CellID->8552],
Cell[4583, 154, 129, 3, 70, "Tutorials",
 CellID->16217]
}, Open  ]],
Cell[CellGroupData[{
Cell[4749, 162, 48, 1, 70, "SeeAlsoSection",
 CellID->693],
Cell[4800, 165, 672, 19, 70, "SeeAlso",
 CellID->15089]
}, Open  ]],
Cell[CellGroupData[{
Cell[5509, 189, 58, 1, 70, "MoreAboutSection",
 CellID->315819894],
Cell[5570, 192, 143, 2, 70, "MoreAbout"],
Cell[5716, 196, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5888, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

