(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8009,        269]
NotebookOptionsPosition[      5857,        202]
NotebookOutlinePosition[      7070,        234]
CellTagsIndexPosition[      7027,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ConjugateTranspose]" :> 
          Documentation`HelpLookup["paclet:ref/character/ConjugateTranspose"],
           "\\[Conjugate]" :> 
          Documentation`HelpLookup["paclet:ref/character/Conjugate"], 
          "\\[Transpose]" :> 
          Documentation`HelpLookup["paclet:ref/character/Transpose"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[ConjugateTranspose]\"\>", 2->"\<\"\\\\[Conjugate]\"\>", 
       3->"\<\"\\\\[Transpose]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[HermitianConjugate]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[HermitianConjugate]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->104743508],

Cell["\\[HermitianConjugate]", "CharacterName",
 CellID->32100],

Cell["Unicode: F3CE.", "Notes",
 CellID->19958],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["hc", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->15171],

Cell["\<\
Superscript postfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->24191],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "\[HermitianConjugate]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23248],

Cell[TextData[{
 "Not the same as keyboard ",
 Cell[BoxData["H"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32122]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->12698],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->5758]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23742],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ConjugateTranspose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ConjugateTranspose"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Conjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Conjugate"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Transpose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Transpose"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->7438]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->60404905],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[HermitianConjugate] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 2.6529956}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3CE. Alias: Esc hc Esc. Superscript postfix operator with \
built-in evaluation rules. m^\\[HermitianConjugate] is by default interpreted \
as ConjugateTranspose[m]. Not the same as keyboard H. ", 
    "synonyms" -> {"hermitian conjugate"}, "title" -> 
    "\\[HermitianConjugate]", "type" -> "Character Name", "uri" -> 
    "ref/character/HermitianConjugate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2250, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2873, 82, 607, 19, 70, "CharacterImage",
 CellID->104743508],
Cell[3483, 103, 63, 1, 70, "CharacterName",
 CellID->32100],
Cell[3549, 106, 47, 1, 70, "Notes",
 CellID->19958],
Cell[3599, 109, 234, 9, 70, "Notes",
 CellID->15171],
Cell[3836, 120, 110, 3, 70, "Notes",
 CellID->24191],
Cell[3949, 125, 374, 13, 70, "Notes",
 CellID->23248],
Cell[4326, 140, 118, 5, 70, "Notes",
 CellID->32122]
}, Open  ]],
Cell[CellGroupData[{
Cell[4481, 150, 53, 1, 70, "TutorialsSection",
 CellID->12698],
Cell[4537, 153, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[4713, 158, 128, 3, 70, "Tutorials",
 CellID->5758]
}, Open  ]],
Cell[CellGroupData[{
Cell[4878, 166, 50, 1, 70, "SeeAlsoSection",
 CellID->23742],
Cell[4931, 169, 644, 18, 70, "SeeAlso",
 CellID->7438]
}, Open  ]],
Cell[CellGroupData[{
Cell[5612, 192, 57, 1, 70, "MoreAboutSection",
 CellID->60404905],
Cell[5672, 195, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5830, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

