(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8220,        272]
NotebookOptionsPosition[      6112,        206]
NotebookOutlinePosition[      7239,        236]
CellTagsIndexPosition[      7196,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Names of Symbols and Mathematical Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Names of Symbols and Mathematical Objects\"\>", 
       3->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ImaginaryJ]" :> 
          Documentation`HelpLookup["paclet:ref/character/ImaginaryJ"], 
          "\\[ExponentialE]" :> 
          Documentation`HelpLookup["paclet:ref/character/ExponentialE"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ImaginaryJ]\"\>", 
       2->"\<\"\\\\[ExponentialE]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ImaginaryI]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ImaginaryI]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->697079052],

Cell["\\[ImaginaryI]", "CharacterName",
 CellID->18222],

Cell["Unicode: F74E.", "Notes",
 CellID->647],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ii", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->10150],

Cell["\<\
Letter\[Hyphen]like form with built\[Hyphen]in value. \
\>", "Notes",
 CellID->15225],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " is interpreted by default as the symbol ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ", representing ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7262]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29382],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->22969],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "Tutorials",
 CellID->9740],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->9526],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ImaginaryJ]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryJ"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ExponentialE"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6287]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->393119016],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ImaginaryI] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 10.6688258}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F74E. Alias: Esc ii Esc. Letter-like form with built-in value. \
I is interpreted by default as the symbol I, representing SqrtBox[RowBox[{-, \
1}]]. ", "synonyms" -> {"imaginary i"}, "title" -> "\\[ImaginaryI]", "type" -> 
    "Character Name", "uri" -> "ref/character/ImaginaryI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2513, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 86, 591, 19, 70, "CharacterImage",
 CellID->697079052],
Cell[3730, 107, 55, 1, 70, "CharacterName",
 CellID->18222],
Cell[3788, 110, 45, 1, 70, "Notes",
 CellID->647],
Cell[3836, 113, 234, 9, 70, "Notes",
 CellID->10150],
Cell[4073, 124, 95, 3, 70, "Notes",
 CellID->15225],
Cell[4171, 129, 393, 15, 70, "Notes",
 CellID->7262]
}, Open  ]],
Cell[CellGroupData[{
Cell[4601, 149, 53, 1, 70, "TutorialsSection",
 CellID->29382],
Cell[4657, 152, 180, 5, 70, "Tutorials",
 CellID->22969],
Cell[4840, 159, 190, 4, 70, "Tutorials",
 CellID->9740],
Cell[5033, 165, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[5243, 173, 49, 1, 70, "SeeAlsoSection",
 CellID->9526],
Cell[5295, 176, 410, 11, 70, "SeeAlso",
 CellID->6287]
}, Open  ]],
Cell[CellGroupData[{
Cell[5742, 192, 58, 1, 70, "MoreAboutSection",
 CellID->393119016],
Cell[5803, 195, 143, 2, 70, "MoreAbout"],
Cell[5949, 199, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6085, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

