(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10510,        361]
NotebookOptionsPosition[      8176,        288]
NotebookOutlinePosition[      9404,        320]
CellTagsIndexPosition[      9361,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RoundImplies]" :> 
          Documentation`HelpLookup["paclet:ref/character/RoundImplies"], 
          "\\[SuchThat]" :> 
          Documentation`HelpLookup["paclet:ref/character/SuchThat"], 
          "\\[RightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrow"], 
          "\\[Rule]" :> Documentation`HelpLookup["paclet:ref/character/Rule"],
           "\\[DoubleRightArrow]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/DoubleRightArrow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[RoundImplies]\"\>", 
       2->"\<\"\\\\[SuchThat]\"\>", 3->"\<\"\\\\[RightArrow]\"\>", 
       4->"\<\"\\\\[Rule]\"\>", 
       5->"\<\"\\\\[DoubleRightArrow]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Implies]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Implies]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->872166591],

Cell["\\[Implies]", "CharacterName",
 CellID->16791],

Cell["Unicode: F523.", "Notes",
 CellID->15024],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["=>", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->10467],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->6850],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Implies]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29934],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Implies]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Implies]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " groups as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Implies]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Implies]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26495],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[DoubleRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->6975],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DoubleRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
  "InlineCharacterName"],
 " is extensible; ",
 Cell[TextData[ButtonBox["\\[Implies]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Implies"]], "InlineCharacterName"],
 " is not. "
}], "Notes",
 CellID->29075]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->7694],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->15787],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->5465],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14762]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25682],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RoundImplies]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RoundImplies"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SuchThat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SuchThat"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->30586]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->805546351],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Implies] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 11.1375878}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F523. Alias: Esc => Esc. Infix operator with built-in \
evaluation rules. x => y is by default interpreted as Implies[x,y]. x => y => \
z groups as x => (y => z). Not the same as \\[DoubleRightArrow]. \
\\[DoubleRightArrow] is extensible; \\[Implies] is not. ", 
    "synonyms" -> {"implies"}, "title" -> "\\[Implies]", "type" -> 
    "Character Name", "uri" -> "ref/character/Implies"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2641, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3264, 90, 585, 19, 70, "CharacterImage",
 CellID->872166591],
Cell[3852, 111, 52, 1, 70, "CharacterName",
 CellID->16791],
Cell[3907, 114, 47, 1, 70, "Notes",
 CellID->15024],
Cell[3957, 117, 234, 9, 70, "Notes",
 CellID->10467],
Cell[4194, 128, 95, 3, 70, "Notes",
 CellID->6850],
Cell[4292, 133, 498, 20, 70, "Notes",
 CellID->29934],
Cell[4793, 155, 786, 34, 70, "Notes",
 CellID->26495],
Cell[5582, 191, 224, 8, 70, "Notes",
 CellID->6975],
Cell[5809, 201, 365, 11, 70, "Notes",
 CellID->29075]
}, Open  ]],
Cell[CellGroupData[{
Cell[6211, 217, 52, 1, 70, "TutorialsSection",
 CellID->7694],
Cell[6266, 220, 144, 3, 70, "Tutorials",
 CellID->15787],
Cell[6413, 225, 179, 5, 70, "Tutorials",
 CellID->5465],
Cell[6595, 232, 129, 3, 70, "Tutorials",
 CellID->14762]
}, Open  ]],
Cell[CellGroupData[{
Cell[6761, 240, 50, 1, 70, "SeeAlsoSection",
 CellID->25682],
Cell[6814, 243, 1079, 30, 70, "SeeAlso",
 CellID->30586]
}, Open  ]],
Cell[CellGroupData[{
Cell[7930, 278, 58, 1, 70, "MoreAboutSection",
 CellID->805546351],
Cell[7991, 281, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[8149, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

