(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6790,        229]
NotebookOptionsPosition[      4815,        168]
NotebookOutlinePosition[      5987,        199]
CellTagsIndexPosition[      5944,        196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NewLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/NewLine"], 
          "\\[NoBreak]" :> 
          Documentation`HelpLookup["paclet:ref/character/NoBreak"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[NewLine]\"\>", 
       2->"\<\"\\\\[NoBreak]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[IndentingNewLine]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[IndentingNewLine]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->155412566],

Cell["\\[IndentingNewLine]", "CharacterName",
 CellID->18571],

Cell["Unicode: F3A3.", "Notes",
 CellID->13114],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["nl", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->18042],

Cell["Raw operator. ", "Notes",
 CellID->7750],

Cell["\<\
Forces a line break in an expression, maintaining the correct indenting level \
based on the environment of the line break. \
\>", "Notes",
 CellID->32749]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->1728],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->9977]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1606],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NoBreak]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NoBreak"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20465]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[IndentingNewLine] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 11.2782164}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3A3. Alias: Esc nl Esc. Raw operator. Forces a line break in \
an expression, maintaining the correct indenting level based on the \
environment of the line break. ", "synonyms" -> {"indenting new line"}, 
    "title" -> "\\[IndentingNewLine]", "type" -> "Character Name", "uri" -> 
    "ref/character/IndentingNewLine"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1987, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2610, 78, 603, 19, 70, "CharacterImage",
 CellID->155412566],
Cell[3216, 99, 61, 1, 70, "CharacterName",
 CellID->18571],
Cell[3280, 102, 47, 1, 70, "Notes",
 CellID->13114],
Cell[3330, 105, 234, 9, 70, "Notes",
 CellID->18042],
Cell[3567, 116, 46, 1, 70, "Notes",
 CellID->7750],
Cell[3616, 119, 165, 4, 70, "Notes",
 CellID->32749]
}, Open  ]],
Cell[CellGroupData[{
Cell[3818, 128, 52, 1, 70, "TutorialsSection",
 CellID->1728],
Cell[3873, 131, 195, 4, 70, "Tutorials",
 CellID->9977]
}, Open  ]],
Cell[CellGroupData[{
Cell[4105, 140, 38, 0, 70, "MoreAboutSection"],
Cell[4146, 142, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4326, 149, 49, 1, 70, "SeeAlsoSection",
 CellID->1606],
Cell[4378, 152, 395, 11, 70, "SeeAlso",
 CellID->20465]
}, Open  ]],
Cell[4788, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

