(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10916,        378]
NotebookOptionsPosition[      8366,        304]
NotebookOutlinePosition[      9868,        339]
CellTagsIndexPosition[      9825,        336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ContourIntegral]" :> 
          Documentation`HelpLookup["paclet:ref/character/ContourIntegral"], 
          "\\[DifferentialD]" :> 
          Documentation`HelpLookup["paclet:ref/character/DifferentialD"], 
          "\\[Integral]" :> 
          Documentation`HelpLookup["paclet:ref/character/Integral"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[ContourIntegral]\"\>", 
       2->"\<\"\\\\[DifferentialD]\"\>", 
       3->"\<\"\\\\[Integral]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Integral]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Integral]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->304563888],

Cell["\\[Integral]", "CharacterName",
 CellID->20760],

Cell["Unicode: 222B.", "Notes",
 CellID->2280],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["int", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->21650],

Cell["\<\
Compound operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->12088],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24966],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Integral]", "a", "b"], TraditionalForm]], 
  "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{"Integral", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " must appear as a subscript and superscript, respectively. "
}], "Notes",
 CellID->21067],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SmallCircle]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default output as ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SmallCircle]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], ")"}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  FormBox["\[SmallCircle]", TraditionalForm]], "InlineMath"],
 " is an operator with a precedence lower than ",
 Cell[BoxData[
  FormBox["\[Star]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15778],

Cell[TextData[{
 "Note the use of ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 ", entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineCharacterName"],
 ", rather than ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1173]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3843],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->5932],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->1576]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24335],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ContourIntegral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ContourIntegral"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->19616]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->533752416],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Integral] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 11.5750990}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 222B. Alias: Esc int Esc. Compound operator with built-in \
evaluation rules. \\[Integral] f d x is by default interpreted as \
Integrate[f,x]. SubsuperscriptBox[\\[Integral], a, b] f d x is by default \
interpreted as Integral[f,{x,a,b}]. a and b must appear as a subscript and \
superscript, respectively. \\[Integral] a () b d x is by default output as \
\\[Integral] (a () b) d x whenever () is an operator with a precedence lower \
than *. Note the use of d, entered as Esc dd Esc or \\[DifferentialD], rather \
than ordinary d. ", "synonyms" -> {"integral"}, "title" -> "\\[Integral]", 
    "type" -> "Character Name", "uri" -> "ref/character/Integral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2191, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2814, 81, 587, 19, 70, "CharacterImage",
 CellID->304563888],
Cell[3404, 102, 53, 1, 70, "CharacterName",
 CellID->20760],
Cell[3460, 105, 46, 1, 70, "Notes",
 CellID->2280],
Cell[3509, 108, 235, 9, 70, "Notes",
 CellID->21650],
Cell[3747, 119, 99, 3, 70, "Notes",
 CellID->12088],
Cell[3849, 124, 588, 23, 70, "Notes",
 CellID->24966],
Cell[4440, 149, 842, 32, 70, "Notes",
 CellID->21067],
Cell[5285, 183, 1192, 46, 70, "Notes",
 CellID->15778],
Cell[6480, 231, 502, 16, 70, "Notes",
 CellID->1173]
}, Open  ]],
Cell[CellGroupData[{
Cell[7019, 252, 52, 1, 70, "TutorialsSection",
 CellID->3843],
Cell[7074, 255, 143, 3, 70, "Tutorials",
 CellID->5932],
Cell[7220, 260, 128, 3, 70, "Tutorials",
 CellID->1576]
}, Open  ]],
Cell[CellGroupData[{
Cell[7385, 268, 50, 1, 70, "SeeAlsoSection",
 CellID->24335],
Cell[7438, 271, 645, 18, 70, "SeeAlso",
 CellID->19616]
}, Open  ]],
Cell[CellGroupData[{
Cell[8120, 294, 58, 1, 70, "MoreAboutSection",
 CellID->533752416],
Cell[8181, 297, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[8339, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

