(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8686,        290]
NotebookOptionsPosition[      6340,        220]
NotebookOutlinePosition[      7716,        254]
CellTagsIndexPosition[      7673,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"], 
          "\\[InvisibleComma]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleComma"], 
          "\\[RawAt]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawAt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[InvisibleSpace]\"\>", 
       2->"\<\"\\\\[InvisibleComma]\"\>", 
       3->"\<\"\\\\[RawAt]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[InvisibleApplication]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[InvisibleApplication]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->422948787],

Cell["\\[InvisibleApplication]", "CharacterName",
 CellID->5542],

Cell["Unicode: F76D.", "Notes",
 CellID->26124],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["@", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32569],

Cell["\<\
Structural element with built\[Hyphen]in meaning. \
\>", "Notes",
 CellID->8581],

Cell[TextData[{
 Cell["\\[InvisibleApplication]", "InlineCharacterName"],
 " is by default not visible on display, but is interpreted as function \
application. "
}], "Notes",
 CellID->2643],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]@\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "@", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21827],

Cell[TextData[{
 Cell["\\[InvisibleApplication]", "InlineCharacterName"],
 " can be used as an invisible separator between functions or between \
functions and their arguments. "
}], "Notes",
 CellID->18201]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4502],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->19023],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->12038]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->13101],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleComma"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawAt]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawAt"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->4205]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[InvisibleApplication] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 18.3408972}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F76D. Alias: Esc @ Esc. Structural element with built-in \
meaning. \\[InvisibleApplication] is by default not visible on display, but \
is interpreted as function application. f Esc @ Esc x is interpreted as f@x \
or f[x]. \\[InvisibleApplication] can be used as an invisible separator \
between functions or between functions and their arguments. ", 
    "synonyms" -> {"invisible application"}, "title" -> 
    "\\[InvisibleApplication]", "type" -> "Character Name", "uri" -> 
    "ref/character/InvisibleApplication"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2295, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2918, 83, 611, 19, 70, "CharacterImage",
 CellID->422948787],
Cell[3532, 104, 64, 1, 70, "CharacterName",
 CellID->5542],
Cell[3599, 107, 47, 1, 70, "Notes",
 CellID->26124],
Cell[3649, 110, 233, 9, 70, "Notes",
 CellID->32569],
Cell[3885, 121, 90, 3, 70, "Notes",
 CellID->8581],
Cell[3978, 126, 190, 5, 70, "Notes",
 CellID->2643],
Cell[4171, 133, 530, 22, 70, "Notes",
 CellID->21827],
Cell[4704, 157, 207, 5, 70, "Notes",
 CellID->18201]
}, Open  ]],
Cell[CellGroupData[{
Cell[4948, 167, 52, 1, 70, "TutorialsSection",
 CellID->4502],
Cell[5003, 170, 144, 3, 70, "Tutorials",
 CellID->19023],
Cell[5150, 175, 196, 4, 70, "Tutorials",
 CellID->12038]
}, Open  ]],
Cell[CellGroupData[{
Cell[5383, 184, 38, 0, 70, "MoreAboutSection"],
Cell[5424, 186, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5604, 193, 50, 1, 70, "SeeAlsoSection",
 CellID->13101],
Cell[5657, 196, 641, 19, 70, "SeeAlso",
 CellID->4205]
}, Open  ]],
Cell[6313, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

