(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8030,        262]
NotebookOptionsPosition[      5897,        198]
NotebookOutlinePosition[      7173,        230]
CellTagsIndexPosition[      7130,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[AlignmentMarker]" :> 
          Documentation`HelpLookup["paclet:ref/character/AlignmentMarker"], 
          "\\[Null]" :> Documentation`HelpLookup["paclet:ref/character/Null"],
           "\\[VeryThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/VeryThinSpace"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[AlignmentMarker]\"\>", 
       2->"\<\"\\\\[Null]\"\>", 3->"\<\"\\\\[VeryThinSpace]\"\>", 
       4->"\<\"\\\\[RawSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[InvisibleSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[InvisibleSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->68809365],

Cell["\\[InvisibleSpace]", "CharacterName",
 CellID->11929],

Cell["Unicode: F360.", "Notes",
 CellID->7440],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["is", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->3527],

Cell["Spacing character. ", "Notes",
 CellID->28540],

Cell[TextData[{
 Cell["\\[InvisibleSpace]", "InlineCharacterName"],
 " is by default not visible on display, but is interpreted on input as an \
ordinary space. "
}], "Notes",
 CellID->13886],

Cell[TextData[{
 Cell["\\[InvisibleSpace]", "InlineCharacterName"],
 " can be used as an invisible separator between variables that are being \
multiplied together, as in ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "y"}], "TI"], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18443]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9047],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->610]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22971],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[AlignmentMarker]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Null]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->26471]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[InvisibleSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 18.9190370}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F360. Alias: Esc is Esc. Spacing character. \\[InvisibleSpace] \
is by default not visible on display, but is interpreted on input as an \
ordinary space. \\[InvisibleSpace] can be used as an invisible separator \
between variables that are being multiplied together, as in xy. ", 
    "synonyms" -> {"invisible space"}, "title" -> "\\[InvisibleSpace]", 
    "type" -> "Character Name", "uri" -> "ref/character/InvisibleSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2270, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2893, 82, 598, 19, 70, "CharacterImage",
 CellID->68809365],
Cell[3494, 103, 59, 1, 70, "CharacterName",
 CellID->11929],
Cell[3556, 106, 46, 1, 70, "Notes",
 CellID->7440],
Cell[3605, 109, 233, 9, 70, "Notes",
 CellID->3527],
Cell[3841, 120, 52, 1, 70, "Notes",
 CellID->28540],
Cell[3896, 123, 191, 5, 70, "Notes",
 CellID->13886],
Cell[4090, 130, 312, 10, 70, "Notes",
 CellID->18443]
}, Open  ]],
Cell[CellGroupData[{
Cell[4439, 145, 52, 1, 70, "TutorialsSection",
 CellID->9047],
Cell[4494, 148, 194, 4, 70, "Tutorials",
 CellID->610]
}, Open  ]],
Cell[CellGroupData[{
Cell[4725, 157, 38, 0, 70, "MoreAboutSection"],
Cell[4766, 159, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4946, 166, 50, 1, 70, "SeeAlsoSection",
 CellID->22971],
Cell[4999, 169, 856, 24, 70, "SeeAlso",
 CellID->26471]
}, Open  ]],
Cell[5870, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

