(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9472,        317]
NotebookOptionsPosition[      6996,        242]
NotebookOutlinePosition[      8376,        276]
CellTagsIndexPosition[      8333,        273]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftDoubleBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftDoubleBracketingBar"], "\\[LeftTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftTee"], 
          "\\[VerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalBar"], 
          "\\[VerticalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalLine"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[LeftDoubleBracketingBar]\"\>", 2->"\<\"\\\\[LeftTee]\"\>",
        3->"\<\"\\\\[VerticalBar]\"\>", 
       4->"\<\"\\\\[VerticalLine]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftBracketingBar]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftBracketingBar]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->205970619],

Cell["\\[LeftBracketingBar]", "CharacterName",
 CellID->1925],

Cell["Unicode: F603.", "Notes",
 CellID->27201],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["l|", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->4855],

Cell["Matchfix operator. ", "Notes",
 CellID->15304],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftBracketingBar]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightBracketingBar]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BracketingBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BracketingBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22378],

Cell[TextData[{
 "Used in mathematics to indicate absolute value (",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 "), determinant (",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 "), and other notions of evaluating size or magnitude. "
}], "Notes",
 CellID->1391],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28433],

Cell["\<\
Drawn in monospaced fonts with a small left\[Hyphen]pointing tee to indicate \
direction. \
\>", "Notes",
 CellID->13260],

Cell["Extensible character. ", "Notes",
 CellID->2725]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->22826],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->28125],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->690]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->3935],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftDoubleBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftDoubleBracketingBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftTee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalLine"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->25847]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->514100292],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftBracketingBar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 27.4348800}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F603. Alias: Esc l| Esc. Matchfix operator. | x | is by default \
interpreted as BracketingBar[x]. Used in mathematics to indicate absolute \
value (Abs), determinant (Det), and other notions of evaluating size or \
magnitude. Not the same as \\[VerticalBar]. Drawn in monospaced fonts with a \
small left-pointing tee to indicate direction. Extensible character. ", 
    "synonyms" -> {"left bracketing bar"}, "title" -> "\\[LeftBracketingBar]",
     "type" -> "Character Name", "uri" -> 
    "ref/character/LeftBracketingBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2400, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3023, 85, 605, 19, 70, "CharacterImage",
 CellID->205970619],
Cell[3631, 106, 61, 1, 70, "CharacterName",
 CellID->1925],
Cell[3695, 109, 47, 1, 70, "Notes",
 CellID->27201],
Cell[3745, 112, 233, 9, 70, "Notes",
 CellID->4855],
Cell[3981, 123, 52, 1, 70, "Notes",
 CellID->15304],
Cell[4036, 126, 501, 18, 70, "Notes",
 CellID->22378],
Cell[4540, 146, 393, 13, 70, "Notes",
 CellID->1391],
Cell[4936, 161, 212, 7, 70, "Notes",
 CellID->28433],
Cell[5151, 170, 131, 4, 70, "Notes",
 CellID->13260],
Cell[5285, 176, 54, 1, 70, "Notes",
 CellID->2725]
}, Open  ]],
Cell[CellGroupData[{
Cell[5376, 182, 53, 1, 70, "TutorialsSection",
 CellID->22826],
Cell[5432, 185, 180, 5, 70, "Tutorials",
 CellID->28125],
Cell[5615, 192, 127, 3, 70, "Tutorials",
 CellID->690]
}, Open  ]],
Cell[CellGroupData[{
Cell[5779, 200, 49, 1, 70, "SeeAlsoSection",
 CellID->3935],
Cell[5831, 203, 882, 24, 70, "SeeAlso",
 CellID->25847]
}, Open  ]],
Cell[CellGroupData[{
Cell[6750, 232, 58, 1, 70, "MoreAboutSection",
 CellID->514100292],
Cell[6811, 235, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6969, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

