(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8790,        298]
NotebookOptionsPosition[      6240,        221]
NotebookOutlinePosition[      7649,        255]
CellTagsIndexPosition[      7606,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftBracketingBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftBracketingBar"], 
          "\\[DoubleVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleVerticalBar"], 
          "\\[RightDoubleBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RightDoubleBracketingBar"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[LeftBracketingBar]\"\>", 
       2->"\<\"\\\\[DoubleVerticalBar]\"\>", 
       3->"\<\"\\\\[RightDoubleBracketingBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftDoubleBracketingBar]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftDoubleBracketingBar]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->251641530],

Cell["\\[LeftDoubleBracketingBar]", "CharacterName",
 CellID->90],

Cell["Unicode: F605.", "Notes",
 CellID->12747],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["l||", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->7965],

Cell["Matchfix operator. ", "Notes",
 CellID->1124],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftDoubleBracketingBar]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightDoubleBracketingBar]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoubleBracketingBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DoubleBracketingBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30284],

Cell["Used in mathematics to indicate taking a norm. ", "Notes",
 CellID->32525],

Cell["Sometimes used for determinant. ", "Notes",
 CellID->15953],

Cell["Sometimes used to indicate a matrix. ", "Notes",
 CellID->21792],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->12110],

Cell["\<\
Drawn in monospaced fonts with a small left\[Hyphen]pointing tee to indicate \
direction. \
\>", "Notes",
 CellID->12197],

Cell["Extensible character. ", "Notes",
 CellID->497]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20805],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->4112]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27730],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightDoubleBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightDoubleBracketingBar"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->11231]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->116600121],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftDoubleBracketingBar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 34.3256814}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F605. Alias: Esc l|| Esc. Matchfix operator. || x || is by \
default interpreted as DoubleBracketingBar[x]. Used in mathematics to \
indicate taking a norm. Sometimes used for determinant. Sometimes used to \
indicate a matrix. Not the same as \\[DoubleVerticalBar]. Drawn in monospaced \
fonts with a small left-pointing tee to indicate direction. Extensible \
character. ", "synonyms" -> {"left double bracketing bar"}, "title" -> 
    "\\[LeftDoubleBracketingBar]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftDoubleBracketingBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2130, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2753, 80, 617, 19, 70, "CharacterImage",
 CellID->251641530],
Cell[3373, 101, 65, 1, 70, "CharacterName",
 CellID->90],
Cell[3441, 104, 47, 1, 70, "Notes",
 CellID->12747],
Cell[3491, 107, 234, 9, 70, "Notes",
 CellID->7965],
Cell[3728, 118, 51, 1, 70, "Notes",
 CellID->1124],
Cell[3782, 121, 525, 18, 70, "Notes",
 CellID->30284],
Cell[4310, 141, 80, 1, 70, "Notes",
 CellID->32525],
Cell[4393, 144, 65, 1, 70, "Notes",
 CellID->15953],
Cell[4461, 147, 70, 1, 70, "Notes",
 CellID->21792],
Cell[4534, 150, 227, 8, 70, "Notes",
 CellID->12110],
Cell[4764, 160, 131, 4, 70, "Notes",
 CellID->12197],
Cell[4898, 166, 53, 1, 70, "Notes",
 CellID->497]
}, Open  ]],
Cell[CellGroupData[{
Cell[4988, 172, 53, 1, 70, "TutorialsSection",
 CellID->20805],
Cell[5044, 175, 128, 3, 70, "Tutorials",
 CellID->4112]
}, Open  ]],
Cell[CellGroupData[{
Cell[5209, 183, 50, 1, 70, "SeeAlsoSection",
 CellID->27730],
Cell[5262, 186, 695, 20, 70, "SeeAlso",
 CellID->11231]
}, Open  ]],
Cell[CellGroupData[{
Cell[5994, 211, 58, 1, 70, "MoreAboutSection",
 CellID->116600121],
Cell[6055, 214, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6213, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

