(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7885,        267]
NotebookOptionsPosition[      5661,        198]
NotebookOutlinePosition[      6895,        230]
CellTagsIndexPosition[      6852,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightGuillemet"], 
          "\\[LessLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessLess"], 
          "\\[LeftSkeleton]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftSkeleton"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[RightGuillemet]\"\>", 
       2->"\<\"\\\\[LessLess]\"\>", 
       3->"\<\"\\\\[LeftSkeleton]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftGuillemet]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftGuillemet]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->186061824],

Cell["\\[LeftGuillemet]", "CharacterName",
 CellID->21813],

Cell["Unicode: 00AB.", "Notes",
 CellID->428468396],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["g<<", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->1244],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->20359],

Cell["\<\
Used as opening quotation marks in languages such as Spanish. \
\>", "Notes",
 CellID->26850],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LessLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessLess"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->20456],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->25605],

Cell["Guillemet is sometimes misspelled as guillemot. ", "Notes",
 CellID->25810]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8428],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->3032],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightGuillemet"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LessLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessLess"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->23266]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->436447507],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftGuillemet] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 35.2475800}", "context" -> "", 
    "keywords" -> {"left guillemet"}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00AB. Alias: Esc g<< Esc. Letter-like form. Used as opening \
quotation marks in languages such as Spanish. Not the same as \\[LessLess]. \
Not the same as \\[LeftSkeleton]. Guillemet is sometimes misspelled as \
guillemot. ", "synonyms" -> {"left guillemet"}, "title" -> 
    "\\[LeftGuillemet]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftGuillemet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2133, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2756, 81, 597, 19, 70, "CharacterImage",
 CellID->186061824],
Cell[3356, 102, 58, 1, 70, "CharacterName",
 CellID->21813],
Cell[3417, 105, 51, 1, 70, "Notes",
 CellID->428468396],
Cell[3471, 108, 234, 9, 70, "Notes",
 CellID->1244],
Cell[3708, 119, 59, 1, 70, "Notes",
 CellID->20359],
Cell[3770, 122, 103, 3, 70, "Notes",
 CellID->26850],
Cell[3876, 127, 206, 7, 70, "Notes",
 CellID->20456],
Cell[4085, 136, 214, 7, 70, "Notes",
 CellID->25605],
Cell[4302, 145, 81, 1, 70, "Notes",
 CellID->25810]
}, Open  ]],
Cell[CellGroupData[{
Cell[4420, 151, 52, 1, 70, "TutorialsSection",
 CellID->8428],
Cell[4475, 154, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4685, 162, 49, 1, 70, "SeeAlsoSection",
 CellID->3032],
Cell[4737, 165, 641, 18, 70, "SeeAlso",
 CellID->23266]
}, Open  ]],
Cell[CellGroupData[{
Cell[5415, 188, 58, 1, 70, "MoreAboutSection",
 CellID->436447507],
Cell[5476, 191, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5634, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

