(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8468,        279]
NotebookOptionsPosition[      6315,        213]
NotebookOutlinePosition[      7556,        245]
CellTagsIndexPosition[      7513,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"], 
          "\\[RightModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightModified"], 
          "\\[RawLeftBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawLeftBracket"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[ControlKey]\"\>", 
       2->"\<\"\\\\[CommandKey]\"\>", 3->"\<\"\\\\[RightModified]\"\>", 
       4->"\<\"\\\\[RawLeftBracket]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftModified]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftModified]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->95436028],

Cell["\\[LeftModified]", "CharacterName",
 CellID->7862],

Cell["Unicode: F76B.", "Notes",
 CellID->5320],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["[", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->27101],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->32555],

Cell["Used in documenting control and command characters. ", "Notes",
 CellID->4685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["key", "TI"]], "InlineFormula"],
 Cell["\\[LeftModified]", "InlineCharacterName"],
 Cell[BoxData[
  StyleBox["char", "TI"]], "InlineFormula"],
 Cell[BoxData[
  ButtonBox["\\[RightModified]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/RightModified"]], 
  "InlineCharacterName"],
 " is used to indicate that ",
 Cell[BoxData[
  StyleBox["char", "TI"]], "InlineFormula"],
 " should be typed while ",
 Cell[BoxData[
  StyleBox["key", "TI"]], "InlineFormula"],
 " is being pressed. "
}], "Notes",
 CellID->28086],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RawLeftBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLeftBracket"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->13117]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->22741],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->19763]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18667],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightModified"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawLeftBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawLeftBracket"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->28953]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftModified] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 35.3725832}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F76B. Alias: Esc [ Esc. Letter-like form. Used in documenting \
control and command characters. key\\[LeftModified]char\\[RightModified] is \
used to indicate that char should be typed while key is being pressed. Not \
the same as \\[RawLeftBracket]. ", "synonyms" -> {"left modified"}, "title" -> 
    "\\[LeftModified]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftModified"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2303, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2926, 83, 594, 19, 70, "CharacterImage",
 CellID->95436028],
Cell[3523, 104, 56, 1, 70, "CharacterName",
 CellID->7862],
Cell[3582, 107, 46, 1, 70, "Notes",
 CellID->5320],
Cell[3631, 110, 233, 9, 70, "Notes",
 CellID->27101],
Cell[3867, 121, 59, 1, 70, "Notes",
 CellID->32555],
Cell[3929, 124, 84, 1, 70, "Notes",
 CellID->4685],
Cell[4016, 127, 566, 19, 70, "Notes",
 CellID->28086],
Cell[4585, 148, 221, 8, 70, "Notes",
 CellID->13117]
}, Open  ]],
Cell[CellGroupData[{
Cell[4843, 161, 53, 1, 70, "TutorialsSection",
 CellID->22741],
Cell[4899, 164, 196, 4, 70, "Tutorials",
 CellID->19763]
}, Open  ]],
Cell[CellGroupData[{
Cell[5132, 173, 38, 0, 70, "MoreAboutSection"],
Cell[5173, 175, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5353, 182, 50, 1, 70, "SeeAlsoSection",
 CellID->18667],
Cell[5406, 185, 867, 23, 70, "SeeAlso",
 CellID->28953]
}, Open  ]],
Cell[6288, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

