(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8867,        286]
NotebookOptionsPosition[      6707,        221]
NotebookOutlinePosition[      8004,        254]
CellTagsIndexPosition[      7961,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\[RightGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightSkeleton"], 
          "\\[SkeletonIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SkeletonIndicator"], 
          "\\[Ellipsis]" :> 
          Documentation`HelpLookup["paclet:ref/character/Ellipsis"], 
          "\\[ErrorIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/ErrorIndicator"], 
          "\\[LeftGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftGuillemet"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\[RightGuillemet]\"\>", 
       2->"\<\"\\\\[SkeletonIndicator]\"\>", 3->"\<\"\\\\[Ellipsis]\"\>", 
       4->"\<\"\\\\[ErrorIndicator]\"\>", 
       5->"\<\"\\\\[LeftGuillemet]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LeftSkeleton]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LeftSkeleton]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->110102790],

Cell["\\[LeftSkeleton]", "CharacterName",
 CellID->24727],

Cell["Unicode: F761.", "Notes",
 CellID->25868],

Cell["Uninterpretable element. ", "Notes",
 CellID->18964],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftSkeleton]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightSkeleton]", TraditionalForm]], "InlineMath"],
 " is used on output to indicate ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " omitted pieces in an expression obtained from ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29555],

Cell[TextData[{
 Cell["\\[LeftSkeleton]", "InlineCharacterName"],
 " indicates the presence of missing information, and so by default generates \
an error if you try to interpret it. "
}], "Notes",
 CellID->7905],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LeftGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftGuillemet"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->21289]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19207],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->15355]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10341],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SkeletonIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SkeletonIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Ellipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Ellipsis"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ErrorIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ErrorIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftGuillemet"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->17049]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LeftSkeleton] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 42.4821402}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F761. Uninterpretable element. << n >> is used on output to \
indicate n omitted pieces in an expression obtained from Short or Shallow. \
\\[LeftSkeleton] indicates the presence of missing information, and so by \
default generates an error if you try to interpret it. Not the same as \
\\[LeftGuillemet]. ", "synonyms" -> {"left skeleton"}, "title" -> 
    "\\[LeftSkeleton]", "type" -> "Character Name", "uri" -> 
    "ref/character/LeftSkeleton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2467, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3090, 86, 595, 19, 70, "CharacterImage",
 CellID->110102790],
Cell[3688, 107, 57, 1, 70, "CharacterName",
 CellID->24727],
Cell[3748, 110, 47, 1, 70, "Notes",
 CellID->25868],
Cell[3798, 113, 58, 1, 70, "Notes",
 CellID->18964],
Cell[3859, 116, 660, 24, 70, "Notes",
 CellID->29555],
Cell[4522, 142, 212, 5, 70, "Notes",
 CellID->7905],
Cell[4737, 149, 216, 7, 70, "Notes",
 CellID->21289]
}, Open  ]],
Cell[CellGroupData[{
Cell[4990, 161, 53, 1, 70, "TutorialsSection",
 CellID->19207],
Cell[5046, 164, 196, 4, 70, "Tutorials",
 CellID->15355]
}, Open  ]],
Cell[CellGroupData[{
Cell[5279, 173, 38, 0, 70, "MoreAboutSection"],
Cell[5320, 175, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5500, 182, 50, 1, 70, "SeeAlsoSection",
 CellID->10341],
Cell[5553, 185, 1112, 31, 70, "SeeAlso",
 CellID->17049]
}, Open  ]],
Cell[6680, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

