(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9054,        297]
NotebookOptionsPosition[      6980,        232]
NotebookOutlinePosition[      8084,        262]
CellTagsIndexPosition[      8041,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LessSlantEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessSlantEqual"], 
          "\\[LessFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessFullEqual"], 
          "\\[NotLessEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotLessEqual"], 
          "\\[DoubleLeftArrow]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/DoubleLeftArrow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[LessSlantEqual]\"\>", 
       2->"\<\"\\\\[LessFullEqual]\"\>", 3->"\<\"\\\\[NotLessEqual]\"\>", 
       4->"\<\"\\\\[DoubleLeftArrow]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>", 
       3->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LessEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LessEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->74945425],

Cell["\\[LessEqual]", "CharacterName",
 CellID->12948],

Cell["Unicode: 2264.", "Notes",
 CellID->12040],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["<=", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->18424],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->21301],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[LessEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LessEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LessEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27781]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30702],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->30293],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->25896]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18455],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LessSlantEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessSlantEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LessFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessFullEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotLessEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotLessEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleLeftArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleLeftArrow"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->20979]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->227136767],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LessEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 51.2792404}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2264. Alias: Esc <= Esc. Infix operator with built-in \
evaluation rules. x <= y is by default interpreted as LessEqual[x,y]. ", 
    "synonyms" -> {"less equal"}, "title" -> "\\[LessEqual]", "type" -> 
    "Character Name", "uri" -> "ref/character/LessEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2744, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3367, 91, 588, 19, 70, "CharacterImage",
 CellID->74945425],
Cell[3958, 112, 54, 1, 70, "CharacterName",
 CellID->12948],
Cell[4015, 115, 47, 1, 70, "Notes",
 CellID->12040],
Cell[4065, 118, 234, 9, 70, "Notes",
 CellID->18424],
Cell[4302, 129, 96, 3, 70, "Notes",
 CellID->21301],
Cell[4401, 134, 504, 20, 70, "Notes",
 CellID->27781]
}, Open  ]],
Cell[CellGroupData[{
Cell[4942, 159, 53, 1, 70, "TutorialsSection",
 CellID->30702],
Cell[4998, 162, 144, 3, 70, "Tutorials",
 CellID->30293],
Cell[5145, 167, 129, 3, 70, "Tutorials",
 CellID->25896]
}, Open  ]],
Cell[CellGroupData[{
Cell[5311, 175, 50, 1, 70, "SeeAlsoSection",
 CellID->18455],
Cell[5364, 178, 887, 25, 70, "SeeAlso",
 CellID->20979]
}, Open  ]],
Cell[CellGroupData[{
Cell[6288, 208, 58, 1, 70, "MoreAboutSection",
 CellID->227136767],
Cell[6349, 211, 143, 2, 70, "MoreAbout"],
Cell[6495, 215, 283, 8, 70, "MoreAbout"],
Cell[6781, 225, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6953, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

