(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7843,        264]
NotebookOptionsPosition[      5850,        202]
NotebookOutlinePosition[      6975,        232]
CellTagsIndexPosition[      6932,        229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LessEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessEqual"], 
          "\\[LessFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessFullEqual"], 
          "\\[NotLessSlantEqual]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NotLessSlantEqual"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[LessEqual]\"\>", 
       2->"\<\"\\\\[LessFullEqual]\"\>", 
       3->"\<\"\\\\[NotLessSlantEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LessSlantEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LessSlantEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->37945604],

Cell["\\[LessSlantEqual]", "CharacterName",
 CellID->17670],

Cell["Unicode: 2A7D.", "Notes",
 CellID->12455],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["</", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->24711],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->6221],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[LessSlantEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LessEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LessEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31680]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->18569]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23666],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LessEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LessFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessFullEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotLessSlantEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotLessSlantEqual"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->3092]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->233409623],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LessSlantEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 58.3419212}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2A7D. Alias: Esc </ Esc. Infix operator with built-in \
evaluation rules. x <= y is by default interpreted as LessEqual[x,y]. ", 
    "synonyms" -> {"less slant equal"}, "title" -> "\\[LessSlantEqual]", 
    "type" -> "Character Name", "uri" -> "ref/character/LessSlantEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2265, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2888, 83, 598, 19, 70, "CharacterImage",
 CellID->37945604],
Cell[3489, 104, 59, 1, 70, "CharacterName",
 CellID->17670],
Cell[3551, 107, 47, 1, 70, "Notes",
 CellID->12455],
Cell[3601, 110, 234, 9, 70, "Notes",
 CellID->24711],
Cell[3838, 121, 95, 3, 70, "Notes",
 CellID->6221],
Cell[3936, 126, 509, 20, 70, "Notes",
 CellID->31680]
}, Open  ]],
Cell[CellGroupData[{
Cell[4482, 151, 53, 1, 70, "TutorialsSection",
 CellID->20037],
Cell[4538, 154, 129, 3, 70, "Tutorials",
 CellID->18569]
}, Open  ]],
Cell[CellGroupData[{
Cell[4704, 162, 50, 1, 70, "SeeAlsoSection",
 CellID->23666],
Cell[4757, 165, 650, 18, 70, "SeeAlso",
 CellID->3092]
}, Open  ]],
Cell[CellGroupData[{
Cell[5444, 188, 58, 1, 70, "MoreAboutSection",
 CellID->233409623],
Cell[5505, 191, 143, 2, 70, "MoreAbout"],
Cell[5651, 195, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5823, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

