(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9048,        305]
NotebookOptionsPosition[      6835,        236]
NotebookOutlinePosition[      8012,        267]
CellTagsIndexPosition[      7969,        264]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Equal]" :> 
          Documentation`HelpLookup["paclet:ref/character/Equal"], 
          "\\[NotEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotEqual"], 
          "\\[Congruent]" :> 
          Documentation`HelpLookup["paclet:ref/character/Congruent"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Equal]\"\>", 
       2->"\<\"\\\\[NotEqual]\"\>", 
       3->"\<\"\\\\[Congruent]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LongEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LongEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->500006289],

Cell["\\[LongEqual]", "CharacterName",
 CellID->27707],

Cell["Unicode: F7D9.", "Notes",
 CellID->1146],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->16678],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[LongEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30942],

Cell[TextData[{
 Cell["\\[LongEqual]", "InlineCharacterName"],
 " is drawn longer than ",
 Cell[TextData[ButtonBox["\\[RawEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawEqual"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->20145],

Cell[TextData[{
 "Used as an alternative to ",
 Cell[TextData[ButtonBox["\\[Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->17330]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30961],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->30047],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->24770],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->7426]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22686],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Congruent]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Congruent"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->1705]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->7413931],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LongEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 40, 59.1856928}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F7D9. Infix operator with built-in evaluation rules. x == y is \
by default interpreted as Equal[x,y] or x==y. \\[LongEqual] is drawn longer \
than \\[RawEqual]. Used as an alternative to \\[Equal]. ", 
    "synonyms" -> {"long equal"}, "title" -> "\\[LongEqual]", "type" -> 
    "Character Name", "uri" -> "ref/character/LongEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2512, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3135, 87, 589, 19, 70, "CharacterImage",
 CellID->500006289],
Cell[3727, 108, 54, 1, 70, "CharacterName",
 CellID->27707],
Cell[3784, 111, 46, 1, 70, "Notes",
 CellID->1146],
Cell[3833, 114, 96, 3, 70, "Notes",
 CellID->16678],
Cell[3932, 119, 607, 25, 70, "Notes",
 CellID->30942],
Cell[4542, 146, 259, 8, 70, "Notes",
 CellID->20145],
Cell[4804, 156, 210, 7, 70, "Notes",
 CellID->17330]
}, Open  ]],
Cell[CellGroupData[{
Cell[5051, 168, 53, 1, 70, "TutorialsSection",
 CellID->30961],
Cell[5107, 171, 144, 3, 70, "Tutorials",
 CellID->30047],
Cell[5254, 176, 180, 5, 70, "Tutorials",
 CellID->24770],
Cell[5437, 183, 128, 3, 70, "Tutorials",
 CellID->7426]
}, Open  ]],
Cell[CellGroupData[{
Cell[5602, 191, 50, 1, 70, "SeeAlsoSection",
 CellID->22686],
Cell[5655, 194, 613, 17, 70, "SeeAlso",
 CellID->1705]
}, Open  ]],
Cell[CellGroupData[{
Cell[6305, 216, 56, 1, 70, "MoreAboutSection",
 CellID->7413931],
Cell[6364, 219, 143, 2, 70, "MoreAbout"],
Cell[6510, 223, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[6808, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

