(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8819,        292]
NotebookOptionsPosition[      6752,        227]
NotebookOutlinePosition[      7884,        257]
CellTagsIndexPosition[      7841,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrow"], 
          "\\[DoubleLongRightArrow]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/DoubleLongRightArrow"], "\\[LongLeftArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LongLeftArrow"], 
          "\\[LongLeftRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LongLeftRightArrow"],
           "\\[Rule]" :> 
          Documentation`HelpLookup["paclet:ref/character/Rule"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RightArrow]\"\>", 
       2->"\<\"\\\\[DoubleLongRightArrow]\"\>", 
       3->"\<\"\\\\[LongLeftArrow]\"\>", 
       4->"\<\"\\\\[LongLeftRightArrow]\"\>", 
       5->"\<\"\\\\[Rule]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[LongRightArrow]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[LongRightArrow]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->202903525],

Cell["\\[LongRightArrow]", "CharacterName",
 CellID->7030],

Cell["Unicode: 27F6.", "Notes",
 CellID->18138],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["-->", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->24932],

Cell["Infix arrow operator. ", "Notes",
 CellID->7001],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[LongRightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LongRightArrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LongRightArrow"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29102],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->16191]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3406],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->17804],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->8579]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28965],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleLongRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleLongRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LongLeftArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LongLeftArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LongLeftRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LongLeftRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->37]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->324023234],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[LongRightArrow] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 6.3421260}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 27F6. Alias: Esc --> Esc. Infix arrow operator. x --> y is by \
default interpreted as LongRightArrow[x,y]. Not the same as \\[Rule]. ", 
    "synonyms" -> {"long right arrow"}, "title" -> "\\[LongRightArrow]", 
    "type" -> "Character Name", "uri" -> "ref/character/LongRightArrow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2533, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3156, 87, 599, 19, 70, "CharacterImage",
 CellID->202903525],
Cell[3758, 108, 58, 1, 70, "CharacterName",
 CellID->7030],
Cell[3819, 111, 47, 1, 70, "Notes",
 CellID->18138],
Cell[3869, 114, 235, 9, 70, "Notes",
 CellID->24932],
Cell[4107, 125, 54, 1, 70, "Notes",
 CellID->7001],
Cell[4164, 128, 519, 20, 70, "Notes",
 CellID->29102],
Cell[4686, 150, 198, 7, 70, "Notes",
 CellID->16191]
}, Open  ]],
Cell[CellGroupData[{
Cell[4921, 162, 52, 1, 70, "TutorialsSection",
 CellID->3406],
Cell[4976, 165, 163, 3, 70, "Tutorials",
 CellID->17804],
Cell[5142, 170, 128, 3, 70, "Tutorials",
 CellID->8579]
}, Open  ]],
Cell[CellGroupData[{
Cell[5307, 178, 50, 1, 70, "SeeAlsoSection",
 CellID->28965],
Cell[5360, 181, 1109, 31, 70, "SeeAlso",
 CellID->37]
}, Open  ]],
Cell[CellGroupData[{
Cell[6506, 217, 58, 1, 70, "MoreAboutSection",
 CellID->324023234],
Cell[6567, 220, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6725, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

