(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7617,        259]
NotebookOptionsPosition[      5560,        193]
NotebookOutlinePosition[      6633,        223]
CellTagsIndexPosition[      6590,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Angstrom]" :> 
          Documentation`HelpLookup["paclet:ref/character/Angstrom"], "\\[Mu]" :> 
          Documentation`HelpLookup["paclet:ref/character/Mu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Angstrom]\"\>", 
       2->"\<\"\\\\[Mu]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Variant Letters" :> 
          Documentation`HelpLookup["paclet:guide/VariantLetters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Variant Letters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Micro]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Micro]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->117985145],

Cell["\\[Micro]", "CharacterName",
 CellID->18596],

Cell["Unicode: 00B5.", "Notes",
 CellID->387312450],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["mi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32076],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->24729],

Cell[TextData[{
 "Used as a prefix in units to denote ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->5413],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Mu]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Mu"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->16603]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29591],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->17403],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1042],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Angstrom]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Angstrom"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Mu]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Mu"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->30540]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->283270468],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Variant Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariantLetters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Micro] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 14.3267054}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00B5. Alias: Esc mi Esc. Letter-like form. Used as a prefix in \
units to denote 10^-6. Not the same as \\[Mu]. ", "synonyms" -> {"micro"}, 
    "title" -> "\\[Micro]", "type" -> "Character Name", "uri" -> 
    "ref/character/Micro"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2235, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2858, 81, 581, 19, 70, "CharacterImage",
 CellID->117985145],
Cell[3442, 102, 50, 1, 70, "CharacterName",
 CellID->18596],
Cell[3495, 105, 51, 1, 70, "Notes",
 CellID->387312450],
Cell[3549, 108, 234, 9, 70, "Notes",
 CellID->32076],
Cell[3786, 119, 59, 1, 70, "Notes",
 CellID->24729],
Cell[3848, 122, 200, 8, 70, "Notes",
 CellID->5413],
Cell[4051, 132, 194, 7, 70, "Notes",
 CellID->16603]
}, Open  ]],
Cell[CellGroupData[{
Cell[4282, 144, 53, 1, 70, "TutorialsSection",
 CellID->29591],
Cell[4338, 147, 163, 3, 70, "Tutorials",
 CellID->17403],
Cell[4504, 152, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4714, 160, 49, 1, 70, "SeeAlsoSection",
 CellID->1042],
Cell[4766, 163, 387, 11, 70, "SeeAlso",
 CellID->30540]
}, Open  ]],
Cell[CellGroupData[{
Cell[5190, 179, 58, 1, 70, "MoreAboutSection",
 CellID->283270468],
Cell[5251, 182, 143, 2, 70, "MoreAbout"],
Cell[5397, 186, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5533, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

