(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8208,        271]
NotebookOptionsPosition[      6084,        205]
NotebookOutlinePosition[      7297,        237]
CellTagsIndexPosition[      7254,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NegativeMediumSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeMediumSpace"], "\\[ThickSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThickSpace"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"], 
          "\\[NegativeThinSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeThinSpace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[NegativeMediumSpace]\"\>", 
       2->"\<\"\\\\[ThickSpace]\"\>", 3->"\<\"\\\\[RawSpace]\"\>", 
       4->"\<\"\\\\[NegativeThinSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NegativeThickSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NegativeThickSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->168816166],

Cell["\\[NegativeThickSpace]", "CharacterName",
 CellID->24654],

Cell["Unicode: F384.", "Notes",
 CellID->9067],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["-\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[SpaceIndicator]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->26930],

Cell["Negative spacing character. ", "Notes",
 CellID->3826],

Cell["Used to bring characters on either side closer together. ", "Notes",
 CellID->2852],

Cell[TextData[{
 "Width: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "5"}], "/", "18"}], TraditionalForm]], "InlineMath"],
 " em. "
}], "Notes",
 CellID->5675],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24177]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20734],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->23893]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19959],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NegativeMediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeMediumSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThickSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->2118]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NegativeThickSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 15.2486040}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F384. Alias: Esc -     Esc. Negative spacing character. Used to \
bring characters on either side closer together. Width: -5/18 em. Interpreted \
by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"negative thick space"}, "title" -> 
    "\\[NegativeThickSpace]", "type" -> "Character Name", "uri" -> 
    "ref/character/NegativeThickSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2336, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2959, 84, 607, 19, 70, "CharacterImage",
 CellID->168816166],
Cell[3569, 105, 63, 1, 70, "CharacterName",
 CellID->24654],
Cell[3635, 108, 46, 1, 70, "Notes",
 CellID->9067],
Cell[3684, 111, 303, 10, 70, "Notes",
 CellID->26930],
Cell[3990, 123, 60, 1, 70, "Notes",
 CellID->3826],
Cell[4053, 126, 89, 1, 70, "Notes",
 CellID->2852],
Cell[4145, 129, 173, 8, 70, "Notes",
 CellID->5675],
Cell[4321, 139, 235, 7, 70, "Notes",
 CellID->24177]
}, Open  ]],
Cell[CellGroupData[{
Cell[4593, 151, 53, 1, 70, "TutorialsSection",
 CellID->20734],
Cell[4649, 154, 196, 4, 70, "Tutorials",
 CellID->23893]
}, Open  ]],
Cell[CellGroupData[{
Cell[4882, 163, 38, 0, 70, "MoreAboutSection"],
Cell[4923, 165, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5103, 172, 50, 1, 70, "SeeAlsoSection",
 CellID->19959],
Cell[5156, 175, 886, 25, 70, "SeeAlso",
 CellID->2118]
}, Open  ]],
Cell[6057, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

