(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7852,        262]
NotebookOptionsPosition[      5718,        196]
NotebookOutlinePosition[      6941,        228]
CellTagsIndexPosition[      6898,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NegativeThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NegativeThinSpace"], 
          "\\[VeryThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/VeryThinSpace"], 
          "\\[NegativeVeryThinSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeVeryThinSpace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[NegativeThinSpace]\"\>", 
       2->"\<\"\\\\[VeryThinSpace]\"\>", 
       3->"\<\"\\\\[NegativeVeryThinSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NegativeVeryThinSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NegativeVeryThinSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->394608037],

Cell["\\[NegativeVeryThinSpace]", "CharacterName",
 CellID->17908],

Cell["Unicode: F380.", "Notes",
 CellID->14898],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["-\[SpaceIndicator]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->23063],

Cell["Negative spacing character. ", "Notes",
 CellID->30584],

Cell["Used to bring characters on either side closer together. ", "Notes",
 CellID->3925],

Cell[TextData[{
 "Width: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "/", "18"}], TraditionalForm]], "InlineMath"],
 " em. "
}], "Notes",
 CellID->558],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->6914]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23130],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->30803]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27000],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NegativeThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeVeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->15651]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NegativeVeryThinSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 15.5454866}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F380. Alias: Esc -  Esc. Negative spacing character. Used to \
bring characters on either side closer together. Width: -1/18 em. Interpreted \
by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"negative very thin space"}, "title" -> 
    "\\[NegativeVeryThinSpace]", "type" -> "Character Name", "uri" -> 
    "ref/character/NegativeVeryThinSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2222, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2845, 82, 613, 19, 70, "CharacterImage",
 CellID->394608037],
Cell[3461, 103, 66, 1, 70, "CharacterName",
 CellID->17908],
Cell[3530, 106, 47, 1, 70, "Notes",
 CellID->14898],
Cell[3580, 109, 250, 9, 70, "Notes",
 CellID->23063],
Cell[3833, 120, 61, 1, 70, "Notes",
 CellID->30584],
Cell[3897, 123, 89, 1, 70, "Notes",
 CellID->3925],
Cell[3989, 126, 172, 8, 70, "Notes",
 CellID->558],
Cell[4164, 136, 234, 7, 70, "Notes",
 CellID->6914]
}, Open  ]],
Cell[CellGroupData[{
Cell[4435, 148, 53, 1, 70, "TutorialsSection",
 CellID->23130],
Cell[4491, 151, 196, 4, 70, "Tutorials",
 CellID->30803]
}, Open  ]],
Cell[CellGroupData[{
Cell[4724, 160, 38, 0, 70, "MoreAboutSection"],
Cell[4765, 162, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4945, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->27000],
Cell[4998, 172, 678, 19, 70, "SeeAlso",
 CellID->15651]
}, Open  ]],
Cell[5691, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

