(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7571,        257]
NotebookOptionsPosition[      5501,        194]
NotebookOutlinePosition[      6712,        225]
CellTagsIndexPosition[      6669,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LessLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/LessLess"], 
          "\\[NotLessLess]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotLessLess"], 
          "\\[NotNestedLessLess]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NotNestedLessLess"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[LessLess]\"\>", 
       2->"\<\"\\\\[NotLessLess]\"\>", 
       3->"\<\"\\\\[NotNestedLessLess]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[NestedLessLess]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[NestedLessLess]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->2090439],

Cell["\\[NestedLessLess]", "CharacterName",
 CellID->21891],

Cell["Unicode: 2AA1.", "Notes",
 CellID->15323],

Cell["Infix ordering operator. ", "Notes",
 CellID->29246],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[NestedLessLess]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestedLessLess",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestedLessLess"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19778],

Cell["\<\
Used to denote \[OpenCurlyDoubleQuote]much less than\[CloseCurlyDoubleQuote]. \
\
\>", "Notes",
 CellID->21089],

Cell["\<\
Occasionally used in measure theory to denote \
\[OpenCurlyDoubleQuote]absolutely continuous with respect to\
\[CloseCurlyDoubleQuote]. \
\>", "Notes",
 CellID->3698]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3616],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->28900]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->16703],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LessLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessLess"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotLessLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotLessLess"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotNestedLessLess]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotNestedLessLess"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->11962]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NestedLessLess] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 22.4831642}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2AA1. Infix ordering operator. x << y is by default interpreted \
as NestedLessLess[x,y]. Used to denote 'much less than'. Occasionally used in \
measure theory to denote 'absolutely continuous with respect to'. ", 
    "synonyms" -> {"nested less less"}, "title" -> "\\[NestedLessLess]", 
    "type" -> "Character Name", "uri" -> "ref/character/NestedLessLess"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2064, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2687, 80, 597, 19, 70, "CharacterImage",
 CellID->2090439],
Cell[3287, 101, 59, 1, 70, "CharacterName",
 CellID->21891],
Cell[3349, 104, 47, 1, 70, "Notes",
 CellID->15323],
Cell[3399, 107, 58, 1, 70, "Notes",
 CellID->29246],
Cell[3460, 110, 519, 20, 70, "Notes",
 CellID->19778],
Cell[3982, 132, 121, 4, 70, "Notes",
 CellID->21089],
Cell[4106, 138, 176, 5, 70, "Notes",
 CellID->3698]
}, Open  ]],
Cell[CellGroupData[{
Cell[4319, 148, 52, 1, 70, "TutorialsSection",
 CellID->3616],
Cell[4374, 151, 129, 3, 70, "Tutorials",
 CellID->28900]
}, Open  ]],
Cell[CellGroupData[{
Cell[4540, 159, 38, 0, 70, "MoreAboutSection"],
Cell[4581, 161, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4761, 168, 50, 1, 70, "SeeAlsoSection",
 CellID->16703],
Cell[4814, 171, 645, 18, 70, "SeeAlso",
 CellID->11962]
}, Open  ]],
Cell[5474, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

