(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7066,        235]
NotebookOptionsPosition[      4902,        170]
NotebookOutlinePosition[      6202,        203]
CellTagsIndexPosition[      6159,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[IndentingNewLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/IndentingNewLine"], 
          "\\[RawReturn]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawReturn"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[IndentingNewLine]\"\>", 
       2->"\<\"\\\\[RawReturn]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"
\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"
\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->246986997],

Cell["\\[NewLine]", "CharacterName",
 CellID->25198],

Cell["Unicode: 000A.", "Notes",
 CellID->524701834],

Cell["Raw operator. ", "Notes",
 CellID->3241],

Cell["Inserted whenever a raw newline is entered on the keyboard. ", "Notes",
 CellID->19150],

Cell["\<\
Forces a line break in an expression, fixing the indenting level at the time \
when the line break is inserted. \
\>", "Notes",
 CellID->26452],

Cell[TextData[{
 Cell["\\[NewLine]", "InlineCharacterName"],
 " represents a newline on any computer system, independent of the underlying \
character code used on that computer system. "
}], "Notes",
 CellID->19149]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->31600],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->28414]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10742],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[IndentingNewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IndentingNewLine"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawReturn]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawReturn"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->19553]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[NewLine] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 41, 22.7800468}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 000A. Raw operator. Inserted whenever a raw newline is entered \
on the keyboard. Forces a line break in an expression, fixing the indenting \
level at the time when the line break is inserted. \\[NewLine] represents a \
newline on any computer system, independent of the underlying character code \
used on that computer system. ", "synonyms" -> {"new line"}, "title" -> 
    "\\[NewLine]", "type" -> "Character Name", "uri" -> 
    "ref/character/NewLine"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2021, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2644, 78, 567, 21, 70, "CharacterImage",
 CellID->246986997],
Cell[3214, 101, 52, 1, 70, "CharacterName",
 CellID->25198],
Cell[3269, 104, 51, 1, 70, "Notes",
 CellID->524701834],
Cell[3323, 107, 46, 1, 70, "Notes",
 CellID->3241],
Cell[3372, 110, 93, 1, 70, "Notes",
 CellID->19150],
Cell[3468, 113, 153, 4, 70, "Notes",
 CellID->26452],
Cell[3624, 119, 216, 5, 70, "Notes",
 CellID->19149]
}, Open  ]],
Cell[CellGroupData[{
Cell[3877, 129, 53, 1, 70, "TutorialsSection",
 CellID->31600],
Cell[3933, 132, 196, 4, 70, "Tutorials",
 CellID->28414]
}, Open  ]],
Cell[CellGroupData[{
Cell[4166, 141, 38, 0, 70, "MoreAboutSection"],
Cell[4207, 143, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4387, 150, 50, 1, 70, "SeeAlsoSection",
 CellID->10742],
Cell[4440, 153, 420, 12, 70, "SeeAlso",
 CellID->19553]
}, Open  ]],
Cell[4875, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

