(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7691,        264]
NotebookOptionsPosition[      5733,        201]
NotebookOutlinePosition[      6807,        231]
CellTagsIndexPosition[      6764,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CurlyPhi]" :> 
          Documentation`HelpLookup["paclet:ref/character/CurlyPhi"], 
          "\\[CapitalPhi]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalPhi"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[CurlyPhi]\"\>", 
       2->"\<\"\\\\[CapitalPhi]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Phi]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Phi]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->16669035],

Cell["\\[Phi]", "CharacterName",
 CellID->24458],

Cell["Unicode: 03D5.", "Notes",
 CellID->627],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ph", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["phi", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["f", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9017],

Cell["Greek letter. ", "Notes",
 CellID->21394],

Cell[TextData[{
 "Used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15609]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->14878],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->23701],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24621],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CurlyPhi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyPhi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalPhi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalPhi"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->13555]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->653992656],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Phi] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 27.2191964}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03D5. Aliases: Esc ph Esc, Esc phi Esc, Esc f Esc. Greek \
letter. Used in TraditionalForm for EulerPhi and GoldenRatio. ", 
    "synonyms" -> {"phi"}, "title" -> "\\[Phi]", "type" -> "Character Name", 
    "uri" -> "ref/character/Phi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2126, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2749, 80, 576, 19, 70, "CharacterImage",
 CellID->16669035],
Cell[3328, 101, 48, 1, 70, "CharacterName",
 CellID->24458],
Cell[3379, 104, 45, 1, 70, "Notes",
 CellID->627],
Cell[3427, 107, 595, 21, 70, "Notes",
 CellID->9017],
Cell[4025, 130, 47, 1, 70, "Notes",
 CellID->21394],
Cell[4075, 133, 460, 18, 70, "Notes",
 CellID->15609]
}, Open  ]],
Cell[CellGroupData[{
Cell[4572, 156, 53, 1, 70, "TutorialsSection",
 CellID->14878],
Cell[4628, 159, 153, 3, 70, "Tutorials",
 CellID->23701],
Cell[4784, 164, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4994, 172, 50, 1, 70, "SeeAlsoSection",
 CellID->24621],
Cell[5047, 175, 403, 11, 70, "SeeAlso",
 CellID->13555]
}, Open  ]],
Cell[CellGroupData[{
Cell[5487, 191, 58, 1, 70, "MoreAboutSection",
 CellID->653992656],
Cell[5548, 194, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5706, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

