(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10384,        345]
NotebookOptionsPosition[      7842,        269]
NotebookOutlinePosition[      9277,        304]
CellTagsIndexPosition[      9234,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       4->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Coproduct]" :> 
          Documentation`HelpLookup["paclet:ref/character/Coproduct"], 
          "\\[Sum]" :> Documentation`HelpLookup["paclet:ref/character/Sum"], 
          "\\[Times]" :> 
          Documentation`HelpLookup["paclet:ref/character/Times"], 
          "\\[CapitalPi]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalPi"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Coproduct]\"\>", 
       2->"\<\"\\\\[Sum]\"\>", 3->"\<\"\\\\[Times]\"\>", 
       4->"\<\"\\\\[CapitalPi]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Product]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Product]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->244252844],

Cell["\\[Product]", "CharacterName",
 CellID->25467],

Cell["Unicode: 220F.", "Notes",
 CellID->24655],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["prod", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29973],

Cell["\<\
Compound operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->8751],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Product]", "i", 
     SubscriptBox["i", "max"],
     LimitsPositioning->False], "f"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28943],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Product]", 
     SubscriptBox[
      StyleBox[
       RowBox[{"i", "=", "i"}], "TI"], "min"], 
     SubscriptBox["i", "max"],
     LimitsPositioning->False], "f"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30869],

Cell[TextData[{
 "Not the same as the Greek letter ",
 Cell[TextData[ButtonBox["\\[CapitalPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalPi"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24960]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21625],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->6294],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->2746],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->4606]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->11802],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Coproduct]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Coproduct"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Sum]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalPi"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->28451]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->51759267],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Product] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 35.4069060}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 220F. Alias: Esc prod Esc. Compound operator with built-in \
evaluation rules. UnderoverscriptBox[\\[Product], i, SubscriptBox[i, max], \
LimitsPositioning -> False]f is by default interpreted as \
Product[f,{i,i_max}]. UnderoverscriptBox[\\[Product], \
SubscriptBox[StyleBox[RowBox[{i, =, i}], TI], min], SubscriptBox[i, max], \
LimitsPositioning -> False]f is by default interpreted as \
Product[f,{i,i_min,i_max}]. Not the same as the Greek letter \\[CapitalPi]. ",
     "synonyms" -> {"product"}, "title" -> "\\[Product]", "type" -> 
    "Character Name", "uri" -> "ref/character/Product"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2643, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3266, 89, 585, 19, 70, "CharacterImage",
 CellID->244252844],
Cell[3854, 110, 52, 1, 70, "CharacterName",
 CellID->25467],
Cell[3909, 113, 47, 1, 70, "Notes",
 CellID->24655],
Cell[3959, 116, 236, 9, 70, "Notes",
 CellID->29973],
Cell[4198, 127, 98, 3, 70, "Notes",
 CellID->8751],
Cell[4299, 132, 613, 23, 70, "Notes",
 CellID->28943],
Cell[4915, 157, 777, 29, 70, "Notes",
 CellID->30869],
Cell[5695, 188, 225, 7, 70, "Notes",
 CellID->24960]
}, Open  ]],
Cell[CellGroupData[{
Cell[5957, 200, 53, 1, 70, "TutorialsSection",
 CellID->21625],
Cell[6013, 203, 143, 3, 70, "Tutorials",
 CellID->6294],
Cell[6159, 208, 179, 5, 70, "Tutorials",
 CellID->2746],
Cell[6341, 215, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[6517, 220, 128, 3, 70, "Tutorials",
 CellID->4606]
}, Open  ]],
Cell[CellGroupData[{
Cell[6682, 228, 50, 1, 70, "SeeAlsoSection",
 CellID->11802],
Cell[6735, 231, 825, 23, 70, "SeeAlso",
 CellID->28451]
}, Open  ]],
Cell[CellGroupData[{
Cell[7597, 259, 57, 1, 70, "MoreAboutSection",
 CellID->51759267],
Cell[7657, 262, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7815, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

