(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5956,        203]
NotebookOptionsPosition[      4156,        146]
NotebookOutlinePosition[      5204,        175]
CellTagsIndexPosition[      5161,        172]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[InvisibleComma]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleComma"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[InvisibleComma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\",\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\",\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->242044412],

Cell["\\[RawComma]", "CharacterName",
 CellID->20367],

Cell["Unicode: 002C.", "Notes",
 CellID->5980990],

Cell["Raw operator. ", "Notes",
 CellID->19338],

Cell["Equivalent to the ordinary ASCII character with code 44. ", "Notes",
 CellID->30516]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6853],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->11093]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31450],

Cell[TextData[Cell[TextData[ButtonBox["\\[InvisibleComma]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/InvisibleComma"]], "InlineCharacterName"]], "SeeAlso",\

 CellID->15532]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawComma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 43.5477394}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 002C. Raw operator. Equivalent to the ordinary ASCII character \
with code 44. ", "synonyms" -> {"raw comma"}, "title" -> "\\[RawComma]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawComma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1884, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2507, 76, 567, 19, 70, "CharacterImage",
 CellID->242044412],
Cell[3077, 97, 53, 1, 70, "CharacterName",
 CellID->20367],
Cell[3133, 100, 49, 1, 70, "Notes",
 CellID->5980990],
Cell[3185, 103, 47, 1, 70, "Notes",
 CellID->19338],
Cell[3235, 106, 90, 1, 70, "Notes",
 CellID->30516]
}, Open  ]],
Cell[CellGroupData[{
Cell[3362, 112, 52, 1, 70, "TutorialsSection",
 CellID->6853],
Cell[3417, 115, 196, 4, 70, "Tutorials",
 CellID->11093]
}, Open  ]],
Cell[CellGroupData[{
Cell[3650, 124, 38, 0, 70, "MoreAboutSection"],
Cell[3691, 126, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3871, 133, 50, 1, 70, "SeeAlsoSection",
 CellID->31450],
Cell[3924, 136, 190, 5, 70, "SeeAlso",
 CellID->15532]
}, Open  ]],
Cell[4129, 144, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

