(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8596,        291]
NotebookOptionsPosition[      6077,        215]
NotebookOutlinePosition[      7466,        249]
CellTagsIndexPosition[      7423,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawPlus]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawPlus"], 
          "\\[HorizontalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/HorizontalLine"], 
          "\\[Dash]" :> 
          Documentation`HelpLookup["paclet:ref/character/Dash"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RawPlus]\"\>", 
       2->"\<\"\\\\[HorizontalLine]\"\>", 
       3->"\<\"\\\\[Dash]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"-\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"-\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->75809541],

Cell["\\[RawDash]", "CharacterName",
 CellID->19709],

Cell["Unicode: 002D.", "Notes",
 CellID->245490644],

Cell["Raw operator. ", "Notes",
 CellID->3371],

Cell["Equivalent to the ordinary ASCII character with code 45. ", "Notes",
 CellID->16123],

Cell["As an overscript, used to indicate conjugation or negation. ", "Notes",
 CellID->31169],

Cell["Also used to indicate an average value or an upper value. ", "Notes",
 CellID->5764],

Cell["In geometry, used to denote a line segment. ", "Notes",
 CellID->24555],

Cell["As an underscript, used to indicate a lower value. ", "Notes",
 CellID->20434],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "-"]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperMinus"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23095],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], "-"]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubMinus"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12653],

Cell[TextData[{
 "Not the same as the letter\[Hyphen]like form ",
 Cell[TextData[ButtonBox["\\[Dash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Dash"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->31374]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->23820],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->15711]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19910],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawPlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawPlus"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HorizontalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HorizontalLine"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Dash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Dash"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->12718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawDash] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 43.6883680}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 002D. Raw operator. Equivalent to the ordinary ASCII character \
with code 45. As an overscript, used to indicate conjugation or negation. \
Also used to indicate an average value or an upper value. In geometry, used \
to denote a line segment. As an underscript, used to indicate a lower value. \
x^- is interpreted as SuperMinus[x]. x_- is interpreted as SubMinus[x]. Not \
the same as the letter-like form \\[Dash]. ", "synonyms" -> {"raw dash"}, 
    "title" -> "\\[RawDash]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawDash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2132, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2755, 81, 566, 19, 70, "CharacterImage",
 CellID->75809541],
Cell[3324, 102, 52, 1, 70, "CharacterName",
 CellID->19709],
Cell[3379, 105, 51, 1, 70, "Notes",
 CellID->245490644],
Cell[3433, 108, 46, 1, 70, "Notes",
 CellID->3371],
Cell[3482, 111, 90, 1, 70, "Notes",
 CellID->16123],
Cell[3575, 114, 93, 1, 70, "Notes",
 CellID->31169],
Cell[3671, 117, 90, 1, 70, "Notes",
 CellID->5764],
Cell[3764, 120, 77, 1, 70, "Notes",
 CellID->24555],
Cell[3844, 123, 84, 1, 70, "Notes",
 CellID->20434],
Cell[3931, 126, 327, 13, 70, "Notes",
 CellID->23095],
Cell[4261, 141, 321, 13, 70, "Notes",
 CellID->12653],
Cell[4585, 156, 227, 7, 70, "Notes",
 CellID->31374]
}, Open  ]],
Cell[CellGroupData[{
Cell[4849, 168, 53, 1, 70, "TutorialsSection",
 CellID->23820],
Cell[4905, 171, 196, 4, 70, "Tutorials",
 CellID->15711]
}, Open  ]],
Cell[CellGroupData[{
Cell[5138, 180, 38, 0, 70, "MoreAboutSection"],
Cell[5179, 182, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5359, 189, 50, 1, 70, "SeeAlsoSection",
 CellID->19910],
Cell[5412, 192, 623, 18, 70, "SeeAlso",
 CellID->12718]
}, Open  ]],
Cell[6050, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

