(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6525,        221]
NotebookOptionsPosition[      4609,        161]
NotebookOutlinePosition[      5718,        191]
CellTagsIndexPosition[      5675,        188]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawQuote]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawQuote"], 
          "\\[Prime]" :> 
          Documentation`HelpLookup["paclet:ref/character/Prime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RawQuote]\"\>", 
       2->"\<\"\\\\[Prime]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\\\"\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\\\"\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->78913657],

Cell["\\[RawDoubleQuote]", "CharacterName",
 CellID->20425],

Cell["Unicode: 0022.", "Notes",
 CellID->266327975],

Cell["Raw operator. ", "Notes",
 CellID->11121],

Cell["Equivalent to the ordinary ASCII character with code 34. ", "Notes",
 CellID->11278],

Cell[TextData[{
 "Equivalent to \[Backslash]",
 Cell[BoxData["\"\<\>"], "InlineFormula"],
 " in strings. "
}], "Notes",
 CellID->15307]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20931],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->4735]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1789],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawQuote"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Prime]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Prime"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->25995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawDoubleQuote] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 50.4697916}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0022. Raw operator. Equivalent to the ordinary ASCII character \
with code 34. Equivalent to \\\" in strings. ", 
    "synonyms" -> {"raw double quote"}, "title" -> "\\[RawDoubleQuote]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawDoubleQuote"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 78, 572, 19, 70, "CharacterImage",
 CellID->78913657],
Cell[3182, 99, 59, 1, 70, "CharacterName",
 CellID->20425],
Cell[3244, 102, 51, 1, 70, "Notes",
 CellID->266327975],
Cell[3298, 105, 47, 1, 70, "Notes",
 CellID->11121],
Cell[3348, 108, 90, 1, 70, "Notes",
 CellID->11278],
Cell[3441, 111, 135, 5, 70, "Notes",
 CellID->15307]
}, Open  ]],
Cell[CellGroupData[{
Cell[3613, 121, 53, 1, 70, "TutorialsSection",
 CellID->20931],
Cell[3669, 124, 195, 4, 70, "Tutorials",
 CellID->4735]
}, Open  ]],
Cell[CellGroupData[{
Cell[3901, 133, 38, 0, 70, "MoreAboutSection"],
Cell[3942, 135, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4122, 142, 49, 1, 70, "SeeAlsoSection",
 CellID->1789],
Cell[4174, 145, 393, 11, 70, "SeeAlso",
 CellID->25995]
}, Open  ]],
Cell[4582, 159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

