(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6678,        226]
NotebookOptionsPosition[      4773,        166]
NotebookOutlinePosition[      5873,        196]
CellTagsIndexPosition[      5830,        193]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotGreater]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotGreater"], 
          "\\[RightAngleBracket]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RightAngleBracket"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[NotGreater]\"\>", 
       2->"\<\"\\\\[RightAngleBracket]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\">\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\">\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->190140615],

Cell["\\[RawGreater]", "CharacterName",
 CellID->30403],

Cell["Unicode: 003E.", "Notes",
 CellID->868950021],

Cell["Raw operator. ", "Notes",
 CellID->3085],

Cell["Equivalent to the ordinary ASCII character with code 62. ", "Notes",
 CellID->3344],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RightAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngleBracket"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->1311]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21022],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->6221]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6601],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotGreater"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngleBracket"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->8550]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawGreater] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 51.0948076}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 003E. Raw operator. Equivalent to the ordinary ASCII character \
with code 62. Not the same as \\[RightAngleBracket]. ", 
    "synonyms" -> {"raw greater"}, "title" -> "\\[RawGreater]", "type" -> 
    "Character Name", "uri" -> "ref/character/RawGreater"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2038, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2661, 79, 567, 19, 70, "CharacterImage",
 CellID->190140615],
Cell[3231, 100, 55, 1, 70, "CharacterName",
 CellID->30403],
Cell[3289, 103, 51, 1, 70, "Notes",
 CellID->868950021],
Cell[3343, 106, 46, 1, 70, "Notes",
 CellID->3085],
Cell[3392, 109, 89, 1, 70, "Notes",
 CellID->3344],
Cell[3484, 112, 226, 8, 70, "Notes",
 CellID->1311]
}, Open  ]],
Cell[CellGroupData[{
Cell[3747, 125, 53, 1, 70, "TutorialsSection",
 CellID->21022],
Cell[3803, 128, 195, 4, 70, "Tutorials",
 CellID->6221]
}, Open  ]],
Cell[CellGroupData[{
Cell[4035, 137, 38, 0, 70, "MoreAboutSection"],
Cell[4076, 139, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4256, 146, 49, 1, 70, "SeeAlsoSection",
 CellID->6601],
Cell[4308, 149, 423, 12, 70, "SeeAlso",
 CellID->8550]
}, Open  ]],
Cell[4746, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

