(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6586,        223]
NotebookOptionsPosition[      4680,        163]
NotebookOutlinePosition[      5781,        193]
CellTagsIndexPosition[      5738,        190]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Placeholder]" :> 
          Documentation`HelpLookup["paclet:ref/character/Placeholder"], 
          "\\[Sharp]" :> 
          Documentation`HelpLookup["paclet:ref/character/Sharp"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Placeholder]\"\>", 
       2->"\<\"\\\\[Sharp]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"#\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"#\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->30716282],

Cell["\\[RawNumberSign]", "CharacterName",
 CellID->8528],

Cell["Unicode: 0023.", "Notes",
 CellID->489486167],

Cell["Raw operator. ", "Notes",
 CellID->18419],

Cell["Equivalent to the ordinary ASCII character with code 35. ", "Notes",
 CellID->29949],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Sharp]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sharp"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->3203]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18546],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->12752]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->259],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Placeholder]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Placeholder"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Sharp]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sharp"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22461]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawNumberSign] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 58.3449932}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0023. Raw operator. Equivalent to the ordinary ASCII character \
with code 35. Not the same as \\[Sharp]. ", "synonyms" -> {"raw number sign"},
     "title" -> "\\[RawNumberSign]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawNumberSign"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1993, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2616, 78, 566, 19, 70, "CharacterImage",
 CellID->30716282],
Cell[3185, 99, 57, 1, 70, "CharacterName",
 CellID->8528],
Cell[3245, 102, 51, 1, 70, "Notes",
 CellID->489486167],
Cell[3299, 105, 47, 1, 70, "Notes",
 CellID->18419],
Cell[3349, 108, 90, 1, 70, "Notes",
 CellID->29949],
Cell[3442, 111, 199, 7, 70, "Notes",
 CellID->3203]
}, Open  ]],
Cell[CellGroupData[{
Cell[3678, 123, 53, 1, 70, "TutorialsSection",
 CellID->18546],
Cell[3734, 126, 196, 4, 70, "Tutorials",
 CellID->12752]
}, Open  ]],
Cell[CellGroupData[{
Cell[3967, 135, 38, 0, 70, "MoreAboutSection"],
Cell[4008, 137, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4188, 144, 48, 1, 70, "SeeAlsoSection",
 CellID->259],
Cell[4239, 147, 399, 11, 70, "SeeAlso",
 CellID->22461]
}, Open  ]],
Cell[4653, 161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

