(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6297,        211]
NotebookOptionsPosition[      4493,        154]
NotebookOutlinePosition[      5541,        183]
CellTagsIndexPosition[      5498,        180]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Prime]" :> 
          Documentation`HelpLookup["paclet:ref/character/Prime"], 
          "\\[RawDoubleQuote]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawDoubleQuote"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Prime]\"\>", 
       2->"\<\"\\\\[RawDoubleQuote]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"'\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"'\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->479034334],

Cell["\\[RawQuote]", "CharacterName",
 CellID->11872],

Cell["Unicode: 0027.", "Notes",
 CellID->264389234],

Cell["Raw operator. ", "Notes",
 CellID->26388],

Cell["Equivalent to the ordinary ASCII character with code 39. ", "Notes",
 CellID->21204]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19978],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->19580]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23973],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Prime]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Prime"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawDoubleQuote"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->10534]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawQuote] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 42, 58.9543838}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0027. Raw operator. Equivalent to the ordinary ASCII character \
with code 39. ", "synonyms" -> {"raw quote"}, "title" -> "\\[RawQuote]", 
    "type" -> "Character Name", "uri" -> "ref/character/RawQuote"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2003, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2626, 78, 567, 19, 70, "CharacterImage",
 CellID->479034334],
Cell[3196, 99, 53, 1, 70, "CharacterName",
 CellID->11872],
Cell[3252, 102, 51, 1, 70, "Notes",
 CellID->264389234],
Cell[3306, 105, 47, 1, 70, "Notes",
 CellID->26388],
Cell[3356, 108, 90, 1, 70, "Notes",
 CellID->21204]
}, Open  ]],
Cell[CellGroupData[{
Cell[3483, 114, 53, 1, 70, "TutorialsSection",
 CellID->19978],
Cell[3539, 117, 196, 4, 70, "Tutorials",
 CellID->19580]
}, Open  ]],
Cell[CellGroupData[{
Cell[3772, 126, 38, 0, 70, "MoreAboutSection"],
Cell[3813, 128, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3993, 135, 50, 1, 70, "SeeAlsoSection",
 CellID->23973],
Cell[4046, 138, 405, 11, 70, "SeeAlso",
 CellID->10534]
}, Open  ]],
Cell[4466, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

