(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8671,        269]
NotebookOptionsPosition[      6862,        211]
NotebookOutlinePosition[      7919,        241]
CellTagsIndexPosition[      7876,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NonBreakingSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NonBreakingSpace"], 
          "\\[MediumSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/MediumSpace"], 
          "\\[ThickSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThickSpace"], 
          "\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[InvisibleSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleSpace"], 
          "\\[NegativeThickSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NegativeThickSpace"],
           "\\[RoundSpaceIndicator]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RoundSpaceIndicator"], "\\[VeryThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/VeryThinSpace"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[NonBreakingSpace]\"\>", 
       2->"\<\"\\\\[MediumSpace]\"\>", 3->"\<\"\\\\[ThickSpace]\"\>", 
       4->"\<\"\\\\[SpaceIndicator]\"\>", 5->"\<\"\\\\[InvisibleSpace]\"\>", 
       6->"\<\"\\\\[NegativeThickSpace]\"\>", 
       7->"\<\"\\\\[RoundSpaceIndicator]\"\>", 
       8->"\<\"\\\\[VeryThinSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\" \"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\" \"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->134670427],

Cell["\\[RawSpace]", "CharacterName",
 CellID->29225],

Cell["Unicode: 0020.", "Notes",
 CellID->29565],

Cell["Spacing character. ", "Notes",
 CellID->25996],

Cell["Equivalent to the ordinary ASCII character with code 32. ", "Notes",
 CellID->7147]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18200],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->32524]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20657],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NonBreakingSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[MediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/MediumSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThickSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeThickSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RoundSpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RoundSpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->9168]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RawSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 6.4545758}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0020. Spacing character. Equivalent to the ordinary ASCII \
character with code 32. ", "synonyms" -> {"raw space"}, "title" -> 
    "\\[RawSpace]", "type" -> "Character Name", "uri" -> 
    "ref/character/RawSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2948, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3571, 94, 567, 19, 70, "CharacterImage",
 CellID->134670427],
Cell[4141, 115, 53, 1, 70, "CharacterName",
 CellID->29225],
Cell[4197, 118, 47, 1, 70, "Notes",
 CellID->29565],
Cell[4247, 121, 52, 1, 70, "Notes",
 CellID->25996],
Cell[4302, 124, 89, 1, 70, "Notes",
 CellID->7147]
}, Open  ]],
Cell[CellGroupData[{
Cell[4428, 130, 53, 1, 70, "TutorialsSection",
 CellID->18200],
Cell[4484, 133, 196, 4, 70, "Tutorials",
 CellID->32524]
}, Open  ]],
Cell[CellGroupData[{
Cell[4717, 142, 38, 0, 70, "MoreAboutSection"],
Cell[4758, 144, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4938, 151, 50, 1, 70, "SeeAlsoSection",
 CellID->20657],
Cell[4991, 154, 1829, 52, 70, "SeeAlso",
 CellID->9168]
}, Open  ]],
Cell[6835, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

