(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8352,        275]
NotebookOptionsPosition[      6190,        208]
NotebookOutlinePosition[      7421,        240]
CellTagsIndexPosition[      7378,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[EnterKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/EnterKey"], 
          "\\[ReturnIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReturnIndicator"], 
          "\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[EnterKey]\"\>", 
       2->"\<\"\\\\[ReturnIndicator]\"\>", 3->"\<\"\\\\[ControlKey]\"\>", 
       4->"\<\"\\\\[CommandKey]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ReturnKey]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ReturnKey]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->702053285],

Cell["\\[ReturnKey]", "CharacterName",
 CellID->7336],

Cell["Unicode: F766.", "Notes",
 CellID->8327],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]ret", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->8895],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->31113],

Cell[TextData[{
 "Representation of the ",
 StyleBox["Return", "KeyEvent"],
 " key on a keyboard. "
}], "Notes",
 CellID->2056],

Cell["Used in describing how to type textual input. ", "Notes",
 CellID->25189],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ret\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"],
 ". The alias for ",
 Cell[TextData[ButtonBox["\\[ReturnKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnKey"]], "InlineCharacterName"],
 " has a space at the beginning. "
}], "Notes",
 CellID->18035]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29390],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->3678]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25600],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[EnterKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EnterKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->25865]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->644316448],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ReturnKey] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 14.3141520}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F766. Alias: Esc  ret Esc. Letter-like form. Representation of \
the Return key on a keyboard. Used in describing how to type textual input. \
Esc ret Esc is the alias for \\[ReturnIndicator]. The alias for \\[ReturnKey] \
has a space at the beginning. ", "synonyms" -> {"return key"}, "title" -> 
    "\\[ReturnKey]", "type" -> "Character Name", "uri" -> 
    "ref/character/ReturnKey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2291, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2914, 83, 589, 19, 70, "CharacterImage",
 CellID->702053285],
Cell[3506, 104, 53, 1, 70, "CharacterName",
 CellID->7336],
Cell[3562, 107, 46, 1, 70, "Notes",
 CellID->8327],
Cell[3611, 110, 251, 9, 70, "Notes",
 CellID->8895],
Cell[3865, 121, 59, 1, 70, "Notes",
 CellID->31113],
Cell[3927, 124, 127, 5, 70, "Notes",
 CellID->2056],
Cell[4057, 131, 79, 1, 70, "Notes",
 CellID->25189],
Cell[4139, 134, 528, 15, 70, "Notes",
 CellID->18035]
}, Open  ]],
Cell[CellGroupData[{
Cell[4704, 154, 53, 1, 70, "TutorialsSection",
 CellID->29390],
Cell[4760, 157, 195, 4, 70, "Tutorials",
 CellID->3678]
}, Open  ]],
Cell[CellGroupData[{
Cell[4992, 166, 50, 1, 70, "SeeAlsoSection",
 CellID->25600],
Cell[5045, 169, 862, 24, 70, "SeeAlso",
 CellID->25865]
}, Open  ]],
Cell[CellGroupData[{
Cell[5944, 198, 58, 1, 70, "MoreAboutSection",
 CellID->644316448],
Cell[6005, 201, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6163, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

