(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8059,        273]
NotebookOptionsPosition[      5983,        208]
NotebookOutlinePosition[      7143,        239]
CellTagsIndexPosition[      7100,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Element]" :> 
          Documentation`HelpLookup["paclet:ref/character/Element"], 
          "\\[NotReverseElement]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotReverseElement"], 
          "\\[SuchThat]" :> 
          Documentation`HelpLookup["paclet:ref/character/SuchThat"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[Element]\"\>", 
       2->"\<\"\\\\[NotReverseElement]\"\>", 
       3->"\<\"\\\\[SuchThat]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ReverseElement]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ReverseElement]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->505623769],

Cell["\\[ReverseElement]", "CharacterName",
 CellID->29057],

Cell["Unicode: 220B.", "Notes",
 CellID->605],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["mem", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->18197],

Cell["Infix set relation operator. ", "Notes",
 CellID->11831],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[ReverseElement]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReverseElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReverseElement"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18278],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[SuchThat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SuchThat"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->1223]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->5061],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->11160]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7274],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Element"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotReverseElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotReverseElement"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SuchThat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SuchThat"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->5692]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->521366],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ReverseElement] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 14.6422854}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 220B. Alias: Esc mem Esc. Infix set relation operator. x \
\\[ReverseElement] y is by default interpreted as ReverseElement[x,y]. Not \
the same as \\[SuchThat]. ", "synonyms" -> {"reverse element"}, "title" -> 
    "\\[ReverseElement]", "type" -> "Character Name", "uri" -> 
    "ref/character/ReverseElement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 82, 599, 19, 70, "CharacterImage",
 CellID->505623769],
Cell[3457, 103, 59, 1, 70, "CharacterName",
 CellID->29057],
Cell[3519, 106, 45, 1, 70, "Notes",
 CellID->605],
Cell[3567, 109, 235, 9, 70, "Notes",
 CellID->18197],
Cell[3805, 120, 62, 1, 70, "Notes",
 CellID->11831],
Cell[3870, 123, 519, 20, 70, "Notes",
 CellID->18278],
Cell[4392, 145, 205, 7, 70, "Notes",
 CellID->1223]
}, Open  ]],
Cell[CellGroupData[{
Cell[4634, 157, 52, 1, 70, "TutorialsSection",
 CellID->5061],
Cell[4689, 160, 129, 3, 70, "Tutorials",
 CellID->11160]
}, Open  ]],
Cell[CellGroupData[{
Cell[4855, 168, 49, 1, 70, "SeeAlsoSection",
 CellID->7274],
Cell[4907, 171, 636, 18, 70, "SeeAlso",
 CellID->5692]
}, Open  ]],
Cell[CellGroupData[{
Cell[5580, 194, 55, 1, 70, "MoreAboutSection",
 CellID->521366],
Cell[5638, 197, 143, 2, 70, "MoreAbout"],
Cell[5784, 201, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5956, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

