(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12635,        394]
NotebookOptionsPosition[     10089,        317]
NotebookOutlinePosition[     11481,        351]
CellTagsIndexPosition[     11438,        348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LongRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LongRightArrow"], 
          "\\[ShortRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/ShortRightArrow"], 
          "\\[DoubleRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleRightArrow"], 
          "\\[RightTeeArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTeeArrow"], 
          "\\[RightArrowBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrowBar"], 
          "\\[UpperRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpperRightArrow"], 
          "\\[RightVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightVector"], 
          "\\[RightTriangle]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTriangle"], 
          "\\[LeftArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftArrow"], 
          "\\[HorizontalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/HorizontalLine"], 
          "\\[Implies]" :> 
          Documentation`HelpLookup["paclet:ref/character/Implies"], 
          "\\[Rule]" :> 
          Documentation`HelpLookup["paclet:ref/character/Rule"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[LongRightArrow]\"\>", 
       2->"\<\"\\\\[ShortRightArrow]\"\>", 
       3->"\<\"\\\\[DoubleRightArrow]\"\>", 4->"\<\"\\\\[RightTeeArrow]\"\>", 
       5->"\<\"\\\\[RightArrowBar]\"\>", 6->"\<\"\\\\[UpperRightArrow]\"\>", 
       7->"\<\"\\\\[RightVector]\"\>", 8->"\<\"\\\\[RightTriangle]\"\>", 
       9->"\<\"\\\\[LeftArrow]\"\>", 10->"\<\"\\\\[HorizontalLine]\"\>", 
       11->"\<\"\\\\[Implies]\"\>", 
       12->"\<\"\\\\[Rule]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightArrow]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightArrow]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->91745292],

Cell["\\[RightArrow]", "CharacterName",
 CellID->4703],

Cell["Unicode: 2192.", "Notes",
 CellID->29830],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " \[RightArrow] ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RightArrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RightArrow"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28289],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]->", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->7403],

Cell["Infix arrow operator. ", "Notes",
 CellID->10790],

Cell["\<\
Used for many purposes in mathematics to indicate transformation, tending to \
a limit or implication. \
\>", "Notes",
 CellID->12398],

Cell["Used as an overscript to indicate a directed object. ", "Notes",
 CellID->29599],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->18462],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 ". The alias for ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 " has a space at the beginning. "
}], "Notes",
 CellID->20446],

Cell["Extensible character. ", "Notes",
 CellID->19096]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->32619],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->8476],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->11771]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20176],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LongRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LongRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ShortRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ShortRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTeeArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTeeArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrowBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrowBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpperRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpperRightArrow"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightVector"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTriangle"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HorizontalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HorizontalLine"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Implies]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Implies"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->11922]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->81364184],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightArrow] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 22.5018616}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2192. x -> y is by default interpreted as RightArrow[x,y]. \
Alias: Esc  -> Esc. Infix arrow operator. Used for many purposes in \
mathematics to indicate transformation, tending to a limit or implication. \
Used as an overscript to indicate a directed object. Not the same as \
\\[Rule]. Esc -> Esc is the alias for \\[Rule]. The alias for \\[RightArrow] \
has a space at the beginning. Extensible character. ", 
    "synonyms" -> {"right arrow"}, "title" -> "\\[RightArrow]", "type" -> 
    "Character Name", "uri" -> "ref/character/RightArrow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3538, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4161, 105, 590, 19, 70, "CharacterImage",
 CellID->91745292],
Cell[4754, 126, 54, 1, 70, "CharacterName",
 CellID->4703],
Cell[4811, 129, 47, 1, 70, "Notes",
 CellID->29830],
Cell[4861, 132, 439, 17, 70, "Notes",
 CellID->28289],
Cell[5303, 151, 250, 9, 70, "Notes",
 CellID->7403],
Cell[5556, 162, 55, 1, 70, "Notes",
 CellID->10790],
Cell[5614, 165, 144, 4, 70, "Notes",
 CellID->12398],
Cell[5761, 171, 86, 1, 70, "Notes",
 CellID->29599],
Cell[5850, 174, 198, 7, 70, "Notes",
 CellID->18462],
Cell[6051, 183, 504, 14, 70, "Notes",
 CellID->20446],
Cell[6558, 199, 55, 1, 70, "Notes",
 CellID->19096]
}, Open  ]],
Cell[CellGroupData[{
Cell[6650, 205, 53, 1, 70, "TutorialsSection",
 CellID->32619],
Cell[6706, 208, 179, 5, 70, "Tutorials",
 CellID->8476],
Cell[6888, 215, 129, 3, 70, "Tutorials",
 CellID->11771]
}, Open  ]],
Cell[CellGroupData[{
Cell[7054, 223, 50, 1, 70, "SeeAlsoSection",
 CellID->20176],
Cell[7107, 226, 2700, 76, 70, "SeeAlso",
 CellID->11922]
}, Open  ]],
Cell[CellGroupData[{
Cell[9844, 307, 57, 1, 70, "MoreAboutSection",
 CellID->81364184],
Cell[9904, 310, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[10062, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

