(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7921,        268]
NotebookOptionsPosition[      5705,        199]
NotebookOutlinePosition[      6935,        231]
CellTagsIndexPosition[      6892,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftGuillemet"], 
          "\\[GreaterGreater]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterGreater"], 
          "\[RightGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightSkeleton"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftGuillemet]\"\>", 
       2->"\<\"\\\\[GreaterGreater]\"\>", 
       3->"\<\"\[RightGuillemet]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightGuillemet]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightGuillemet]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->7915674],

Cell["\\[RightGuillemet]", "CharacterName",
 CellID->796],

Cell["Unicode: 00BB.", "Notes",
 CellID->61763071],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["g>>", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9696],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->4423],

Cell["\<\
Used as closing quotation marks in languages such as Spanish. \
\>", "Notes",
 CellID->24575],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[GreaterGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterGreater"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->13627],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->21712],

Cell["Guillemet is sometimes misspelled as guillemot. ", "Notes",
 CellID->11747]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->31266],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->29957],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftGuillemet"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[GreaterGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterGreater"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->22385]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->325130444],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightGuillemet] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 30.5333172}", "context" -> "", 
    "keywords" -> {"right guillemet"}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00BB. Alias: Esc g>> Esc. Letter-like form. Used as closing \
quotation marks in languages such as Spanish. Not the same as \
\\[GreaterGreater]. Not the same as >. Guillemet is sometimes misspelled as \
guillemot. ", "synonyms" -> {"right guillemet"}, "title" -> 
    "\\[RightGuillemet]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightGuillemet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2149, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2772, 81, 597, 19, 70, "CharacterImage",
 CellID->7915674],
Cell[3372, 102, 57, 1, 70, "CharacterName",
 CellID->796],
Cell[3432, 105, 50, 1, 70, "Notes",
 CellID->61763071],
Cell[3485, 108, 234, 9, 70, "Notes",
 CellID->9696],
Cell[3722, 119, 58, 1, 70, "Notes",
 CellID->4423],
Cell[3783, 122, 103, 3, 70, "Notes",
 CellID->24575],
Cell[3889, 127, 221, 8, 70, "Notes",
 CellID->13627],
Cell[4113, 137, 216, 7, 70, "Notes",
 CellID->21712],
Cell[4332, 146, 81, 1, 70, "Notes",
 CellID->11747]
}, Open  ]],
Cell[CellGroupData[{
Cell[4450, 152, 53, 1, 70, "TutorialsSection",
 CellID->31266],
Cell[4506, 155, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4716, 163, 50, 1, 70, "SeeAlsoSection",
 CellID->29957],
Cell[4769, 166, 653, 18, 70, "SeeAlso",
 CellID->22385]
}, Open  ]],
Cell[CellGroupData[{
Cell[5459, 189, 58, 1, 70, "MoreAboutSection",
 CellID->325130444],
Cell[5520, 192, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5678, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

