(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8872,        287]
NotebookOptionsPosition[      6712,        222]
NotebookOutlinePosition[      8015,        255]
CellTagsIndexPosition[      7972,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftSkeleton]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftSkeleton"], 
          "\\[SkeletonIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SkeletonIndicator"], 
          "\\[Ellipsis]" :> 
          Documentation`HelpLookup["paclet:ref/character/Ellipsis"], 
          "\\[RightGuillemet]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightGuillemet"], 
          "\\[GreaterGreater]" :> 
          Documentation`HelpLookup["paclet:ref/character/GreaterGreater"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftSkeleton]\"\>", 
       2->"\<\"\\\\[SkeletonIndicator]\"\>", 3->"\<\"\\\\[Ellipsis]\"\>", 
       4->"\<\"\\\\[RightGuillemet]\"\>", 
       5->"\<\"\\\\[GreaterGreater]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightSkeleton]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightSkeleton]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->35075083],

Cell["\\[RightSkeleton]", "CharacterName",
 CellID->21964],

Cell["Unicode: F762.", "Notes",
 CellID->29209],

Cell["Uninterpretable element. ", "Notes",
 CellID->3347],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftSkeleton]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightSkeleton]", TraditionalForm]], "InlineMath"],
 " is used on output to indicate ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " omitted pieces in an expression obtained from ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7030],

Cell[TextData[{
 Cell["\\[RightSkeleton]", "InlineCharacterName"],
 " indicates the presence of missing information, and so by default generates \
an error if you try to interpret it. "
}], "Notes",
 CellID->1413],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightGuillemet"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->11813]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19603],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->591]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31416],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SkeletonIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SkeletonIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Ellipsis]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Ellipsis"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightGuillemet"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[GreaterGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterGreater"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6485]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightSkeleton] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 31.3145872}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F762. Uninterpretable element. << n >> is used on output to \
indicate n omitted pieces in an expression obtained from Short or Shallow. \
\\[RightSkeleton] indicates the presence of missing information, and so by \
default generates an error if you try to interpret it. Not the same as \
\\[RightGuillemet]. ", "synonyms" -> {"right skeleton"}, "title" -> 
    "\\[RightSkeleton]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightSkeleton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2469, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3092, 86, 596, 19, 70, "CharacterImage",
 CellID->35075083],
Cell[3691, 107, 58, 1, 70, "CharacterName",
 CellID->21964],
Cell[3752, 110, 47, 1, 70, "Notes",
 CellID->29209],
Cell[3802, 113, 57, 1, 70, "Notes",
 CellID->3347],
Cell[3862, 116, 659, 24, 70, "Notes",
 CellID->7030],
Cell[4524, 142, 213, 5, 70, "Notes",
 CellID->1413],
Cell[4740, 149, 221, 8, 70, "Notes",
 CellID->11813]
}, Open  ]],
Cell[CellGroupData[{
Cell[4998, 162, 53, 1, 70, "TutorialsSection",
 CellID->19603],
Cell[5054, 165, 194, 4, 70, "Tutorials",
 CellID->591]
}, Open  ]],
Cell[CellGroupData[{
Cell[5285, 174, 38, 0, 70, "MoreAboutSection"],
Cell[5326, 176, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5506, 183, 50, 1, 70, "SeeAlsoSection",
 CellID->31416],
Cell[5559, 186, 1111, 31, 70, "SeeAlso",
 CellID->6485]
}, Open  ]],
Cell[6685, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

