(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9836,        333]
NotebookOptionsPosition[      7680,        265]
NotebookOutlinePosition[      8849,        296]
CellTagsIndexPosition[      8806,        293]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[DoubleRightTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleRightTee"], 
          "\\[RightTeeArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTeeArrow"], 
          "\\[RightTeeVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTeeVector"], 
          "\\[LeftTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftTee"], 
          "\\[DownTee]" :> 
          Documentation`HelpLookup["paclet:ref/character/DownTee"], 
          "\\[RightBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RightBracketingBar"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[DoubleRightTee]\"\>", 
       2->"\<\"\\\\[RightTeeArrow]\"\>", 3->"\<\"\\\\[RightTeeVector]\"\>", 
       4->"\<\"\\\\[LeftTee]\"\>", 5->"\<\"\\\\[DownTee]\"\>", 
       6->"\<\"\\\\[RightBracketingBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightTee]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightTee]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->182573817],

Cell["\\[RightTee]", "CharacterName",
 CellID->4825],

Cell["Unicode: 22A2.", "Notes",
 CellID->941],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["rT", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->2744],

Cell["Infix operator. ", "Notes",
 CellID->9648],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{"RightTee", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20076],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " groups as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2431],

Cell["\<\
Used in mathematics to indicate logical implication or proof. \
\>", "Notes",
 CellID->4574]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->32678],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->18067],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->4660]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21317],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DoubleRightTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleRightTee"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTeeArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTeeArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTeeVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTeeVector"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftTee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DownTee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DownTee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightBracketingBar"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->277]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->209601957],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightTee] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 31.6114698}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22A2. Alias: Esc rT Esc. Infix operator. x |- y is by default \
interpreted as RightTee[x,y]. x |- y |- z groups as x |- (y |- z). Used in \
mathematics to indicate logical implication or proof. ", 
    "synonyms" -> {"right tee"}, "title" -> "\\[RightTee]", "type" -> 
    "Character Name", "uri" -> "ref/character/RightTee"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2664, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3287, 89, 587, 19, 70, "CharacterImage",
 CellID->182573817],
Cell[3877, 110, 52, 1, 70, "CharacterName",
 CellID->4825],
Cell[3932, 113, 45, 1, 70, "Notes",
 CellID->941],
Cell[3980, 116, 233, 9, 70, "Notes",
 CellID->2744],
Cell[4216, 127, 48, 1, 70, "Notes",
 CellID->9648],
Cell[4267, 130, 424, 17, 70, "Notes",
 CellID->20076],
Cell[4694, 149, 789, 34, 70, "Notes",
 CellID->2431],
Cell[5486, 185, 102, 3, 70, "Notes",
 CellID->4574]
}, Open  ]],
Cell[CellGroupData[{
Cell[5625, 193, 53, 1, 70, "TutorialsSection",
 CellID->32678],
Cell[5681, 196, 163, 3, 70, "Tutorials",
 CellID->18067],
Cell[5847, 201, 128, 3, 70, "Tutorials",
 CellID->4660]
}, Open  ]],
Cell[CellGroupData[{
Cell[6012, 209, 50, 1, 70, "SeeAlsoSection",
 CellID->21317],
Cell[6065, 212, 1332, 38, 70, "SeeAlso",
 CellID->277]
}, Open  ]],
Cell[CellGroupData[{
Cell[7434, 255, 58, 1, 70, "MoreAboutSection",
 CellID->209601957],
Cell[7495, 258, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7653, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

